/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import javax.annotation.Nullable;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.expressions.RexNodeExpression;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;

@Internal
public final class ShortcutUtils {
    public static FlinkTypeFactory unwrapTypeFactory(SqlOperatorBinding operatorBinding) {
        return ShortcutUtils.unwrapTypeFactory(operatorBinding.getTypeFactory());
    }

    public static FlinkTypeFactory unwrapTypeFactory(RelNode relNode) {
        return ShortcutUtils.unwrapTypeFactory(relNode.getCluster());
    }

    public static FlinkTypeFactory unwrapTypeFactory(RelOptCluster cluster) {
        return ShortcutUtils.unwrapTypeFactory(cluster.getTypeFactory());
    }

    public static FlinkTypeFactory unwrapTypeFactory(RelDataTypeFactory typeFactory) {
        return (FlinkTypeFactory)typeFactory;
    }

    public static FlinkTypeFactory unwrapTypeFactory(RelBuilder relBuilder) {
        return ShortcutUtils.unwrapTypeFactory(relBuilder.getTypeFactory());
    }

    public static FlinkContext unwrapContext(RelBuilder relBuilder) {
        return ShortcutUtils.unwrapContext(relBuilder.getCluster());
    }

    public static FlinkContext unwrapContext(RelNode relNode) {
        return ShortcutUtils.unwrapContext(relNode.getCluster());
    }

    public static FlinkContext unwrapContext(RelOptCluster cluster) {
        return ShortcutUtils.unwrapContext(cluster.getPlanner());
    }

    public static FlinkContext unwrapContext(RelOptPlanner planner) {
        return ShortcutUtils.unwrapContext(planner.getContext());
    }

    public static FlinkContext unwrapContext(Context context) {
        return context.unwrap(FlinkContext.class);
    }

    public static ReadableConfig unwrapConfig(RelNode relNode) {
        return ShortcutUtils.unwrapContext(relNode).getTableConfig().getConfiguration();
    }

    @Nullable
    public static FunctionDefinition unwrapFunctionDefinition(ResolvedExpression expression2) {
        if (expression2 instanceof CallExpression) {
            CallExpression callExpression = (CallExpression)expression2;
            return callExpression.getFunctionDefinition();
        }
        if (!(expression2 instanceof RexNodeExpression)) {
            return null;
        }
        RexNodeExpression rexNodeExpression = (RexNodeExpression)expression2;
        if (!(rexNodeExpression.getRexNode() instanceof RexCall)) {
            return null;
        }
        return ShortcutUtils.unwrapFunctionDefinition(rexNodeExpression.getRexNode());
    }

    @Nullable
    public static FunctionDefinition unwrapFunctionDefinition(RexNode rexNode) {
        if (!(rexNode instanceof RexCall)) {
            return null;
        }
        RexCall call = (RexCall)rexNode;
        if (!(call.getOperator() instanceof BridgingSqlFunction)) {
            return null;
        }
        return ((BridgingSqlFunction)call.getOperator()).getDefinition();
    }

    private ShortcutUtils() {
    }
}

