/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.common;

import java.util.ArrayList;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalJoin;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalLegacyTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSnapshot;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.physical.common.CommonPhysicalLegacyTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.physical.common.CommonPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.rules.physical.common.CommonLookupJoinRule;
import org.apache.flink.table.planner.plan.schema.TimeIndicatorRelDataType;
import org.apache.flink.table.planner.plan.utils.JoinUtil$;
import org.apache.flink.table.sources.LookupableTableSource;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class CommonLookupJoinRule$class {
    public static boolean matches(CommonLookupJoinRule $this, FlinkLogicalJoin join, FlinkLogicalSnapshot snapshot, TableScan tableScan) {
        if ($this.matches(snapshot)) {
            if ($this.isTableSourceScan(tableScan) && $this.isLookupTableSource(tableScan)) {
                TimeIndicatorRelDataType timeIndicatorRelDataType;
                RelDataType relDataType = snapshot.getPeriod().getType();
                boolean bl = relDataType instanceof TimeIndicatorRelDataType && !(timeIndicatorRelDataType = (TimeIndicatorRelDataType)relDataType).isEventTime();
                boolean isProcessingTime = bl;
                return isProcessingTime;
            }
            return false;
        }
        return false;
    }

    public static boolean isTableSourceScan(CommonLookupJoinRule $this, RelNode relNode) {
        RelNode relNode2 = relNode;
        boolean bl = relNode2 instanceof FlinkLogicalLegacyTableSourceScan ? true : (relNode2 instanceof CommonPhysicalLegacyTableSourceScan ? true : (relNode2 instanceof FlinkLogicalTableSourceScan ? true : relNode2 instanceof CommonPhysicalTableSourceScan));
        boolean bl2 = bl;
        return bl2;
    }

    public static boolean isLookupTableSource(CommonLookupJoinRule $this, RelNode relNode) {
        boolean bl;
        RelNode relNode2 = relNode;
        if (relNode2 instanceof FlinkLogicalLegacyTableSourceScan) {
            FlinkLogicalLegacyTableSourceScan flinkLogicalLegacyTableSourceScan = (FlinkLogicalLegacyTableSourceScan)relNode2;
            bl = flinkLogicalLegacyTableSourceScan.tableSource() instanceof LookupableTableSource;
        } else if (relNode2 instanceof CommonPhysicalLegacyTableSourceScan) {
            CommonPhysicalLegacyTableSourceScan commonPhysicalLegacyTableSourceScan = (CommonPhysicalLegacyTableSourceScan)relNode2;
            bl = commonPhysicalLegacyTableSourceScan.tableSource() instanceof LookupableTableSource;
        } else if (relNode2 instanceof FlinkLogicalTableSourceScan) {
            FlinkLogicalTableSourceScan flinkLogicalTableSourceScan = (FlinkLogicalTableSourceScan)relNode2;
            bl = flinkLogicalTableSourceScan.tableSource() instanceof LookupTableSource;
        } else if (relNode2 instanceof CommonPhysicalTableSourceScan) {
            CommonPhysicalTableSourceScan commonPhysicalTableSourceScan = (CommonPhysicalTableSourceScan)relNode2;
            bl = commonPhysicalTableSourceScan.tableSource() instanceof LookupTableSource;
        } else {
            bl = false;
        }
        return bl;
    }

    public static void validateJoin(CommonLookupJoinRule $this, FlinkLogicalJoin join) {
        ArrayList<Boolean> filterNulls = new ArrayList<Boolean>();
        JoinUtil$.MODULE$.createJoinInfo(join.getLeft(), join.getRight(), join.getCondition(), filterNulls);
        boolean[] filterNulls2 = (boolean[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(filterNulls).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$1) {
                return x$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
        if (Predef$.MODULE$.booleanArrayOps(filterNulls2).contains((Object)BoxesRunTime.boxToBoolean((boolean)false))) {
            throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LookupJoin doesn't support join condition contains 'a IS NOT DISTINCT FROM b' (or "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alternative '(a = b) or (a IS NULL AND b IS NULL)'), the join condition is "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{join.getCondition()}))).toString());
        }
    }

    public static void $init$(CommonLookupJoinRule $this) {
    }
}

