/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkRelFactories;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalWatermarkAssigner;
import org.apache.flink.table.planner.plan.utils.NestedColumn;
import org.apache.flink.table.planner.plan.utils.NestedProjectionUtil;
import org.apache.flink.table.planner.plan.utils.NestedSchema;

public class ProjectWatermarkAssignerTransposeRule
extends RelOptRule {
    public static final ProjectWatermarkAssignerTransposeRule INSTANCE = new ProjectWatermarkAssignerTransposeRule();

    public ProjectWatermarkAssignerTransposeRule() {
        super(ProjectWatermarkAssignerTransposeRule.operand(LogicalProject.class, ProjectWatermarkAssignerTransposeRule.operand(LogicalWatermarkAssigner.class, ProjectWatermarkAssignerTransposeRule.any()), new RelOptRuleOperand[0]), FlinkRelFactories.FLINK_REL_BUILDER(), "FlinkProjectWatermarkAssignerTransposeRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalWatermarkAssigner watermarkAssigner;
        LogicalProject project = (LogicalProject)call.rel(0);
        NestedSchema usedFieldInProjectIncludingRowTimeFields = this.getUsedFieldsInTopLevelProjectAndWatermarkAssigner(project, watermarkAssigner = (LogicalWatermarkAssigner)call.rel(1));
        return usedFieldInProjectIncludingRowTimeFields.columns().size() != watermarkAssigner.getRowType().getFieldCount();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        int indexOfRowTimeInTransposedProject;
        LogicalProject project = (LogicalProject)call.rel(0);
        final LogicalWatermarkAssigner watermarkAssigner = (LogicalWatermarkAssigner)call.rel(1);
        final NestedSchema nestedSchema = this.getUsedFieldsInTopLevelProjectAndWatermarkAssigner(project, watermarkAssigner);
        final FlinkRelBuilder builder = (FlinkRelBuilder)call.builder().push(watermarkAssigner.getInput());
        LinkedList<RexInputRef> transposedProjects = new LinkedList<RexInputRef>();
        LinkedList<String> usedNames = new LinkedList<String>();
        for (NestedColumn column : nestedSchema.columns().values()) {
            column.setIndexOfLeafInNewSchema(transposedProjects.size());
            column.markLeaf();
            usedNames.add(column.name());
            transposedProjects.add(builder.field(column.indexInOriginSchema()));
        }
        String rowTimeName = watermarkAssigner.getRowType().getFieldNames().get(watermarkAssigner.rowtimeFieldIndex());
        if (nestedSchema.columns().get(rowTimeName) == null) {
            int rowTimeIndexInInput = watermarkAssigner.rowtimeFieldIndex();
            indexOfRowTimeInTransposedProject = transposedProjects.size();
            transposedProjects.add(builder.field(rowTimeIndexInInput));
            usedNames.add(rowTimeName);
        } else {
            indexOfRowTimeInTransposedProject = nestedSchema.columns().get(rowTimeName).indexOfLeafInNewSchema();
        }
        builder.project(transposedProjects, usedNames);
        RexNode newWatermarkExpr = watermarkAssigner.watermarkExpr().accept(new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef inputRef) {
                String fieldName = watermarkAssigner.getRowType().getFieldNames().get(inputRef.getIndex());
                return builder.field(nestedSchema.columns().get(fieldName).indexOfLeafInNewSchema());
            }
        });
        builder.watermark(indexOfRowTimeInTransposedProject, newWatermarkExpr);
        List<RexNode> newProjects = NestedProjectionUtil.rewrite(project.getProjects(), nestedSchema, call.builder().getRexBuilder());
        RelNode newProject = builder.project(newProjects, project.getRowType().getFieldNames()).build();
        call.transformTo(newProject);
    }

    private NestedSchema getUsedFieldsInTopLevelProjectAndWatermarkAssigner(LogicalProject project, LogicalWatermarkAssigner watermarkAssigner) {
        ArrayList<RexNode> usedFields = new ArrayList<RexNode>(project.getProjects());
        usedFields.add(watermarkAssigner.watermarkExpr());
        return NestedProjectionUtil.build(usedFields, watermarkAssigner.getRowType());
    }
}

