/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.tablefunctions;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class ReplicateRows
extends TableFunction<Row> {
    private static final long serialVersionUID = 1L;
    private final TypeInformation[] fieldTypes;
    private transient Row reuseRow;

    public ReplicateRows(TypeInformation[] fieldTypes) {
        this.fieldTypes = fieldTypes;
    }

    public void eval(Object ... inputs) {
        int i;
        Preconditions.checkArgument((inputs.length == this.fieldTypes.length + 1 ? 1 : 0) != 0);
        long numRows = (Long)inputs[0];
        if (this.reuseRow == null) {
            this.reuseRow = new Row(this.fieldTypes.length);
        }
        for (i = 0; i < this.fieldTypes.length; ++i) {
            this.reuseRow.setField(i, inputs[i + 1]);
        }
        i = 0;
        while ((long)i < numRows) {
            this.collect(this.reuseRow);
            ++i;
        }
    }

    public TypeInformation<Row> getResultType() {
        return new RowTypeInfo(this.fieldTypes);
    }

    public TypeInformation<?>[] getParameterTypes(Class<?>[] signature) {
        TypeInformation[] paraTypes = new TypeInformation[1 + this.fieldTypes.length];
        paraTypes[0] = Types.LONG;
        System.arraycopy(this.fieldTypes, 0, paraTypes, 1, this.fieldTypes.length);
        return paraTypes;
    }
}

