/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.runtime.functions.aggregate.BuiltInAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class MinWithRetractAggFunction<T extends Comparable<T>>
extends BuiltInAggregateFunction<T, MinWithRetractAccumulator<T>> {
    private static final long serialVersionUID = 4253774292802374843L;
    private transient DataType valueDataType;

    public MinWithRetractAggFunction(LogicalType valueType) {
        this.valueDataType = DataTypeUtils.toInternalDataType((LogicalType)valueType);
    }

    public List<DataType> getArgumentDataTypes() {
        return Collections.singletonList(this.valueDataType);
    }

    public DataType getAccumulatorDataType() {
        return DataTypes.STRUCTURED(MinWithRetractAccumulator.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"min", (DataType)((DataType)this.valueDataType.nullable())), DataTypes.FIELD((String)"mapSize", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"map", (DataType)MapView.newMapViewDataType((DataType)((DataType)this.valueDataType.notNull()), (DataType)DataTypes.BIGINT()))});
    }

    public DataType getOutputDataType() {
        return this.valueDataType;
    }

    public MinWithRetractAccumulator<T> createAccumulator() {
        MinWithRetractAccumulator acc = new MinWithRetractAccumulator();
        acc.min = null;
        acc.mapSize = 0L;
        acc.map = new MapView();
        return acc;
    }

    public void accumulate(MinWithRetractAccumulator<T> acc, T value2) throws Exception {
        if (value2 != null) {
            Long count;
            if (acc.mapSize == 0L || ((Comparable)acc.min).compareTo(value2) > 0) {
                acc.min = value2;
            }
            if ((count = (Long)acc.map.get(value2)) == null) {
                count = 0L;
            }
            if ((count = Long.valueOf(count + 1L)) == 0L) {
                acc.map.remove(value2);
            } else {
                acc.map.put(value2, (Object)count);
            }
            if (count == 1L) {
                MinWithRetractAccumulator<T> minWithRetractAccumulator = acc;
                minWithRetractAccumulator.mapSize = minWithRetractAccumulator.mapSize + 1L;
            }
        }
    }

    public void retract(MinWithRetractAccumulator<T> acc, T value2) throws Exception {
        if (value2 != null) {
            Long count = (Long)acc.map.get(value2);
            if (count == null) {
                count = 0L;
            }
            if ((count = Long.valueOf(count - 1L)) == 0L) {
                acc.map.remove(value2);
                MinWithRetractAccumulator<T> minWithRetractAccumulator = acc;
                minWithRetractAccumulator.mapSize = minWithRetractAccumulator.mapSize - 1L;
                if (acc.mapSize == 0L) {
                    acc.min = null;
                    return;
                }
                if (value2.equals(acc.min)) {
                    this.updateMin(acc);
                }
            } else {
                acc.map.put(value2, (Object)count);
            }
        }
    }

    private void updateMin(MinWithRetractAccumulator<T> acc) throws Exception {
        boolean hasMin = false;
        for (Comparable key : acc.map.keys()) {
            if (hasMin && ((Comparable)acc.min).compareTo(key) <= 0) continue;
            acc.min = key;
            hasMin = true;
        }
        if (!hasMin) {
            acc.mapSize = 0L;
            acc.min = null;
        }
    }

    public void merge(MinWithRetractAccumulator<T> acc, Iterable<MinWithRetractAccumulator<T>> its) throws Exception {
        boolean needUpdateMin = false;
        for (MinWithRetractAccumulator<T> a : its) {
            if (acc.mapSize == 0L || a.mapSize > 0L && a.min != null && ((Comparable)acc.min).compareTo(a.min) > 0) {
                acc.min = a.min;
            }
            for (Map.Entry entry : a.map.entries()) {
                MinWithRetractAccumulator<T> minWithRetractAccumulator;
                long mergedCount;
                Comparable key = (Comparable)entry.getKey();
                Long otherCount = (Long)entry.getValue();
                Long thisCount = (Long)acc.map.get((Object)key);
                if (thisCount == null) {
                    thisCount = 0L;
                }
                if ((mergedCount = otherCount + thisCount) == 0L) {
                    acc.map.remove((Object)key);
                    if (thisCount <= 0L) continue;
                    minWithRetractAccumulator = acc;
                    Long.valueOf(minWithRetractAccumulator.mapSize - 1L);
                    minWithRetractAccumulator.mapSize = minWithRetractAccumulator.mapSize;
                    if (!key.equals(acc.min)) continue;
                    needUpdateMin = true;
                    continue;
                }
                if (mergedCount < 0L) {
                    acc.map.put((Object)key, (Object)mergedCount);
                    if (thisCount <= 0L) continue;
                    minWithRetractAccumulator = acc;
                    Long.valueOf(minWithRetractAccumulator.mapSize - 1L);
                    minWithRetractAccumulator.mapSize = minWithRetractAccumulator.mapSize;
                    if (!key.equals(acc.min)) continue;
                    needUpdateMin = true;
                    continue;
                }
                acc.map.put((Object)key, (Object)mergedCount);
                if (thisCount > 0L) continue;
                minWithRetractAccumulator = acc;
                Long.valueOf(minWithRetractAccumulator.mapSize + 1L);
                minWithRetractAccumulator.mapSize = minWithRetractAccumulator.mapSize;
            }
        }
        if (needUpdateMin) {
            this.updateMin(acc);
        }
    }

    public void resetAccumulator(MinWithRetractAccumulator<T> acc) {
        acc.min = null;
        acc.mapSize = 0L;
        acc.map.clear();
    }

    public T getValue(MinWithRetractAccumulator<T> acc) {
        if (acc.mapSize > 0L) {
            return (T)((Comparable)acc.min);
        }
        return null;
    }

    public static class MinWithRetractAccumulator<T> {
        public T min;
        public Long mapSize;
        public MapView<T, Long> map;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MinWithRetractAccumulator)) {
                return false;
            }
            MinWithRetractAccumulator that = (MinWithRetractAccumulator)o;
            return Objects.equals(this.min, that.min) && Objects.equals(this.mapSize, that.mapSize) && Objects.equals(this.map, that.map);
        }

        public int hashCode() {
            return Objects.hash(this.min, this.mapSize, this.map);
        }
    }
}

