/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.runtime.functions.aggregate.BuiltInAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class FirstValueWithRetractAggFunction<T>
extends BuiltInAggregateFunction<T, FirstValueWithRetractAccumulator<T>> {
    private transient DataType valueDataType;

    public FirstValueWithRetractAggFunction(LogicalType valueType) {
        this.valueDataType = DataTypeUtils.toInternalDataType((LogicalType)valueType);
    }

    public List<DataType> getArgumentDataTypes() {
        return Collections.singletonList(this.valueDataType);
    }

    public DataType getAccumulatorDataType() {
        return DataTypes.STRUCTURED(FirstValueWithRetractAccumulator.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"firstValue", (DataType)((DataType)this.valueDataType.nullable())), DataTypes.FIELD((String)"firstOrder", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"valueToOrderMap", (DataType)MapView.newMapViewDataType((DataType)((DataType)this.valueDataType.notNull()), (DataType)((DataType)DataTypes.ARRAY((DataType)DataTypes.BIGINT()).bridgedTo(List.class)))), DataTypes.FIELD((String)"orderToValueMap", (DataType)MapView.newMapViewDataType((DataType)DataTypes.BIGINT(), (DataType)((DataType)DataTypes.ARRAY((DataType)((DataType)this.valueDataType.notNull())).bridgedTo(List.class))))});
    }

    public DataType getOutputDataType() {
        return this.valueDataType;
    }

    public FirstValueWithRetractAccumulator<T> createAccumulator() {
        FirstValueWithRetractAccumulator acc = new FirstValueWithRetractAccumulator();
        acc.firstValue = null;
        acc.firstOrder = null;
        acc.valueToOrderMap = new MapView();
        acc.orderToValueMap = new MapView();
        return acc;
    }

    public void accumulate(FirstValueWithRetractAccumulator<T> acc, Object value2) throws Exception {
        if (value2 != null) {
            Object v = value2;
            Long order = System.currentTimeMillis();
            ArrayList<Long> orderList = (ArrayList<Long>)acc.valueToOrderMap.get(v);
            if (orderList == null) {
                orderList = new ArrayList<Long>();
            }
            orderList.add(order);
            acc.valueToOrderMap.put(v, orderList);
            this.accumulate(acc, v, order);
        }
    }

    public void accumulate(FirstValueWithRetractAccumulator<T> acc, Object value2, Long order) throws Exception {
        if (value2 != null) {
            ArrayList<Object> valueList;
            Object v = value2;
            Long prevOrder = acc.firstOrder;
            if (prevOrder == null || prevOrder > order) {
                acc.firstValue = v;
                acc.firstOrder = order;
            }
            if ((valueList = (ArrayList<Object>)acc.orderToValueMap.get((Object)order)) == null) {
                valueList = new ArrayList<Object>();
            }
            valueList.add(v);
            acc.orderToValueMap.put((Object)order, valueList);
        }
    }

    public void accumulate(FirstValueWithRetractAccumulator<T> acc, StringData value2) throws Exception {
        if (value2 != null) {
            this.accumulate(acc, ((BinaryStringData)value2).copy());
        }
    }

    public void accumulate(FirstValueWithRetractAccumulator<T> acc, StringData value2, Long order) throws Exception {
        if (value2 != null) {
            this.accumulate(acc, ((BinaryStringData)value2).copy(), order);
        }
    }

    public void retract(FirstValueWithRetractAccumulator<T> acc, Object value2) throws Exception {
        Object v;
        List orderList;
        if (value2 != null && (orderList = (List)acc.valueToOrderMap.get(v = value2)) != null && orderList.size() > 0) {
            Long order = (Long)orderList.get(0);
            orderList.remove(0);
            if (orderList.isEmpty()) {
                acc.valueToOrderMap.remove(v);
            } else {
                acc.valueToOrderMap.put(v, (Object)orderList);
            }
            this.retract(acc, v, order);
        }
    }

    public void retract(FirstValueWithRetractAccumulator<T> acc, Object value2, Long order) throws Exception {
        if (value2 != null) {
            Object v = value2;
            List valueList = (List)acc.orderToValueMap.get((Object)order);
            if (valueList == null) {
                return;
            }
            int index = valueList.indexOf(v);
            if (index >= 0) {
                valueList.remove(index);
                if (valueList.isEmpty()) {
                    acc.orderToValueMap.remove((Object)order);
                } else {
                    acc.orderToValueMap.put((Object)order, (Object)valueList);
                }
            }
            if (v.equals(acc.firstValue)) {
                Long startKey = acc.firstOrder;
                Iterator iter = acc.orderToValueMap.keys().iterator();
                Long nextKey = Long.MAX_VALUE;
                while (iter.hasNext()) {
                    Long key = (Long)iter.next();
                    if (key < startKey || key >= nextKey) continue;
                    nextKey = key;
                }
                if (nextKey != Long.MAX_VALUE) {
                    acc.firstValue = ((List)acc.orderToValueMap.get((Object)nextKey)).get(0);
                    acc.firstOrder = nextKey;
                } else {
                    acc.firstValue = null;
                    acc.firstOrder = null;
                }
            }
        }
    }

    public void resetAccumulator(FirstValueWithRetractAccumulator<T> acc) {
        acc.firstValue = null;
        acc.firstOrder = null;
        acc.valueToOrderMap.clear();
        acc.orderToValueMap.clear();
    }

    public T getValue(FirstValueWithRetractAccumulator<T> acc) {
        return acc.firstValue;
    }

    public static class FirstValueWithRetractAccumulator<T> {
        public T firstValue;
        public Long firstOrder;
        public MapView<T, List<Long>> valueToOrderMap;
        public MapView<Long, List<T>> orderToValueMap;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FirstValueWithRetractAccumulator)) {
                return false;
            }
            FirstValueWithRetractAccumulator that = (FirstValueWithRetractAccumulator)o;
            return Objects.equals(this.firstValue, that.firstValue) && Objects.equals(this.firstOrder, that.firstOrder) && Objects.equals(this.valueToOrderMap, that.valueToOrderMap) && Objects.equals(this.orderToValueMap, that.orderToValueMap);
        }

        public int hashCode() {
            return Objects.hash(this.firstValue, this.firstOrder, this.valueToOrderMap, this.orderToValueMap);
        }
    }
}

