/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.hive.ddl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.sql.parser.hive.ddl.HiveDDLUtils;
import org.apache.flink.sql.parser.hive.ddl.SqlHiveConstraintTrait;
import org.apache.flink.sql.parser.hive.impl.ParseException;
import org.apache.flink.table.factories.FactoryUtil;

public class SqlCreateHiveTable
extends SqlCreateTable {
    public static final String IDENTIFIER = "hive";
    public static final String TABLE_LOCATION_URI = "hive.location-uri";
    public static final String TABLE_IS_EXTERNAL = "hive.is-external";
    public static final String PK_CONSTRAINT_TRAIT = "hive.pk.constraint.trait";
    public static final String NOT_NULL_CONSTRAINT_TRAITS = "hive.not.null.constraint.traits";
    public static final String NOT_NULL_COLS = "hive.not.null.cols";
    private final HiveTableCreationContext creationContext;
    private final SqlNodeList originPropList;
    private final boolean isExternal;
    private final HiveTableRowFormat rowFormat;
    private final HiveTableStoredAs storedAs;
    private final SqlCharStringLiteral location;
    private final SqlNodeList origColList;
    private final SqlNodeList origPartColList;

    public SqlCreateHiveTable(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList columnList, HiveTableCreationContext creationContext, SqlNodeList propertyList, SqlNodeList partColList, @Nullable SqlCharStringLiteral comment2, boolean isTemporary, boolean isExternal, HiveTableRowFormat rowFormat, HiveTableStoredAs storedAs, SqlCharStringLiteral location, boolean ifNotExists) throws ParseException {
        super(pos, tableName, columnList, creationContext.constraints, HiveDDLUtils.checkReservedTableProperties(propertyList), SqlCreateHiveTable.extractPartColIdentifiers(partColList), null, HiveDDLUtils.unescapeStringLiteral(comment2), null, isTemporary, ifNotExists);
        HiveDDLUtils.unescapeProperties(propertyList);
        this.origColList = HiveDDLUtils.deepCopyColList(columnList);
        this.origPartColList = partColList != null ? HiveDDLUtils.deepCopyColList(partColList) : SqlNodeList.EMPTY;
        HiveDDLUtils.convertDataTypes(columnList);
        HiveDDLUtils.convertDataTypes(partColList);
        this.originPropList = new SqlNodeList(propertyList.getList(), propertyList.getParserPosition());
        propertyList.add(HiveDDLUtils.toTableOption(FactoryUtil.CONNECTOR.key(), IDENTIFIER, pos));
        this.isExternal = isExternal;
        if (isExternal) {
            propertyList.add(HiveDDLUtils.toTableOption(TABLE_IS_EXTERNAL, "true", pos));
        }
        if (partColList != null) {
            for (SqlNode partCol : partColList) {
                columnList.add(partCol);
            }
        }
        this.creationContext = creationContext;
        for (SqlTableConstraint tableConstraint : creationContext.constraints) {
            if (!tableConstraint.isPrimaryKey()) {
                throw new ParseException("Only PrimaryKey table constraint is supported at the moment");
            }
            propertyList.add(HiveDDLUtils.toTableOption(PK_CONSTRAINT_TRAIT, String.valueOf(HiveDDLUtils.encodeConstraintTrait(creationContext.pkTrait)), propertyList.getParserPosition()));
        }
        if (creationContext.notNullTraits != null) {
            String notNullTraits = creationContext.notNullTraits.stream().map(HiveDDLUtils::encodeConstraintTrait).map(Object::toString).collect(Collectors.joining(";"));
            propertyList.add(HiveDDLUtils.toTableOption(NOT_NULL_CONSTRAINT_TRAITS, notNullTraits, propertyList.getParserPosition()));
            String notNullCols = creationContext.notNullCols.stream().map(SqlIdentifier::getSimple).collect(Collectors.joining(";"));
            propertyList.add(HiveDDLUtils.toTableOption(NOT_NULL_COLS, notNullCols, propertyList.getParserPosition()));
        }
        this.rowFormat = rowFormat;
        if (rowFormat != null) {
            for (SqlNode node : rowFormat.toPropList()) {
                propertyList.add(node);
            }
        }
        this.storedAs = storedAs;
        if (storedAs != null) {
            for (SqlNode node : storedAs.toPropList()) {
                propertyList.add(node);
            }
        }
        this.location = location;
        if (location != null) {
            propertyList.add(HiveDDLUtils.toTableOption(TABLE_LOCATION_URI, location, location.getParserPosition()));
        }
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        if (this.isTemporary()) {
            writer.keyword("TEMPORARY");
        }
        if (this.isExternal) {
            writer.keyword("EXTERNAL");
        }
        writer.keyword("TABLE");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.getTableName().unparse(writer, leftPrec, rightPrec);
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.create("sds"), "(", ")");
        this.unparseColumns(this.creationContext, this.origColList, writer, leftPrec, rightPrec);
        for (SqlTableConstraint tableConstraint : this.creationContext.constraints) {
            this.printIndent(writer);
            tableConstraint.getConstraintNameIdentifier().ifPresent(name -> {
                writer.keyword("CONSTRAINT");
                name.unparse(writer, leftPrec, rightPrec);
            });
            writer.keyword("PRIMARY KEY");
            SqlWriter.Frame pkFrame = writer.startList("(", ")");
            tableConstraint.getColumns().unparse(writer, leftPrec, rightPrec);
            writer.endList(pkFrame);
            this.creationContext.pkTrait.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.endList(frame);
        this.getComment().ifPresent(c -> {
            writer.keyword("COMMENT");
            c.unparse(writer, leftPrec, rightPrec);
        });
        if (this.origPartColList.size() > 0) {
            writer.newlineAndIndent();
            writer.keyword("PARTITIONED BY");
            SqlWriter.Frame partitionedByFrame = writer.startList("(", ")");
            this.unparseColumns(this.creationContext, this.origPartColList, writer, leftPrec, rightPrec);
            writer.newlineAndIndent();
            writer.endList(partitionedByFrame);
        }
        this.unparseRowFormat(writer, leftPrec, rightPrec);
        this.unparseStoredAs(writer, leftPrec, rightPrec);
        if (this.location != null) {
            writer.newlineAndIndent();
            writer.keyword("LOCATION");
            this.location.unparse(writer, leftPrec, rightPrec);
        }
        if (this.originPropList.size() > 0) {
            writer.newlineAndIndent();
            writer.keyword("TBLPROPERTIES");
            this.unparsePropList(this.originPropList, writer, leftPrec, rightPrec);
        }
    }

    private void unparseStoredAs(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.storedAs == null) {
            return;
        }
        writer.newlineAndIndent();
        writer.keyword("STORED AS");
        if (this.storedAs.fileFormat != null) {
            this.storedAs.fileFormat.unparse(writer, leftPrec, rightPrec);
        } else {
            writer.keyword("INPUTFORMAT");
            this.storedAs.intputFormat.unparse(writer, leftPrec, rightPrec);
            writer.keyword("OUTPUTFORMAT");
            this.storedAs.outputFormat.unparse(writer, leftPrec, rightPrec);
        }
    }

    private void unparseRowFormat(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.rowFormat == null) {
            return;
        }
        writer.newlineAndIndent();
        writer.keyword("ROW FORMAT");
        if (this.rowFormat.serdeClass != null) {
            writer.keyword("SERDE");
            this.rowFormat.serdeClass.unparse(writer, leftPrec, rightPrec);
            if (this.rowFormat.serdeProps != null) {
                writer.keyword("WITH SERDEPROPERTIES");
                this.unparsePropList(this.rowFormat.serdeProps, writer, leftPrec, rightPrec);
            }
        } else {
            SqlCharStringLiteral nullAs;
            SqlCharStringLiteral lineDelim;
            SqlCharStringLiteral mapKeyDelim;
            SqlCharStringLiteral collectionDelim;
            writer.keyword("DELIMITED");
            SqlCharStringLiteral fieldDelim = (SqlCharStringLiteral)this.rowFormat.delimitPropToValue.get("hive.serde.info.prop.field.delim");
            SqlCharStringLiteral escape = (SqlCharStringLiteral)this.rowFormat.delimitPropToValue.get("hive.serde.info.prop.escape.delim");
            if (fieldDelim != null) {
                writer.newlineAndIndent();
                writer.print("  ");
                writer.keyword("FIELDS TERMINATED BY");
                fieldDelim.unparse(writer, leftPrec, rightPrec);
                if (escape != null) {
                    writer.keyword("ESCAPED BY");
                    escape.unparse(writer, leftPrec, rightPrec);
                }
            }
            if ((collectionDelim = (SqlCharStringLiteral)this.rowFormat.delimitPropToValue.get("hive.serde.info.prop.collection.delim")) != null) {
                writer.newlineAndIndent();
                writer.print("  ");
                writer.keyword("COLLECTION ITEMS TERMINATED BY");
                collectionDelim.unparse(writer, leftPrec, rightPrec);
            }
            if ((mapKeyDelim = (SqlCharStringLiteral)this.rowFormat.delimitPropToValue.get("hive.serde.info.prop.mapkey.delim")) != null) {
                writer.newlineAndIndent();
                writer.print("  ");
                writer.keyword("MAP KEYS TERMINATED BY");
                mapKeyDelim.unparse(writer, leftPrec, rightPrec);
            }
            if ((lineDelim = (SqlCharStringLiteral)this.rowFormat.delimitPropToValue.get("hive.serde.info.prop.line.delim")) != null) {
                writer.newlineAndIndent();
                writer.print("  ");
                writer.keyword("LINES TERMINATED BY");
                lineDelim.unparse(writer, leftPrec, rightPrec);
            }
            if ((nullAs = (SqlCharStringLiteral)this.rowFormat.delimitPropToValue.get("hive.serde.info.prop.serialization.null.format")) != null) {
                writer.newlineAndIndent();
                writer.print("  ");
                writer.keyword("NULL DEFINED AS");
                nullAs.unparse(writer, leftPrec, rightPrec);
            }
        }
    }

    private void unparsePropList(SqlNodeList propList, SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame withFrame = writer.startList("(", ")");
        for (SqlNode property : propList) {
            this.printIndent(writer);
            property.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.endList(withFrame);
    }

    private void unparseColumns(HiveTableCreationContext context, SqlNodeList columns, SqlWriter writer, int leftPrec, int rightPrec) {
        List<SqlHiveConstraintTrait> notNullTraits = context.notNullTraits;
        int traitIndex = 0;
        for (SqlNode node : columns) {
            this.printIndent(writer);
            SqlTableColumn.SqlRegularColumn column = (SqlTableColumn.SqlRegularColumn)node;
            column.getName().unparse(writer, leftPrec, rightPrec);
            writer.print(" ");
            column.getType().unparse(writer, leftPrec, rightPrec);
            if (column.getType().getNullable() != null && !column.getType().getNullable().booleanValue()) {
                writer.keyword("NOT NULL");
                notNullTraits.get(traitIndex++).unparse(writer, leftPrec, rightPrec);
            }
            column.getComment().ifPresent(c -> {
                writer.keyword("COMMENT");
                c.unparse(writer, leftPrec, rightPrec);
            });
        }
    }

    private static SqlNodeList extractPartColIdentifiers(SqlNodeList partCols) {
        if (partCols == null) {
            return null;
        }
        SqlNodeList res = new SqlNodeList(partCols.getParserPosition());
        for (SqlNode node : partCols) {
            SqlTableColumn partCol = (SqlTableColumn)node;
            res.add(partCol.getName());
        }
        return res;
    }

    public static class HiveTableRowFormat {
        public static final String SERDE_LIB_CLASS_NAME = "hive.serde.lib.class.name";
        public static final String SERDE_INFO_PROP_PREFIX = "hive.serde.info.prop.";
        public static final String FIELD_DELIM = "hive.serde.info.prop.field.delim";
        public static final String COLLECTION_DELIM = "hive.serde.info.prop.collection.delim";
        public static final String ESCAPE_CHAR = "hive.serde.info.prop.escape.delim";
        public static final String MAPKEY_DELIM = "hive.serde.info.prop.mapkey.delim";
        public static final String LINE_DELIM = "hive.serde.info.prop.line.delim";
        public static final String SERIALIZATION_NULL_FORMAT = "hive.serde.info.prop.serialization.null.format";
        private final SqlParserPos pos;
        private final Map<String, SqlCharStringLiteral> delimitPropToValue = new LinkedHashMap<String, SqlCharStringLiteral>();
        private final SqlCharStringLiteral serdeClass;
        private final SqlNodeList serdeProps;

        private HiveTableRowFormat(SqlParserPos pos, SqlCharStringLiteral fieldsTerminator, SqlCharStringLiteral escape, SqlCharStringLiteral collectionTerminator, SqlCharStringLiteral mapKeyTerminator, SqlCharStringLiteral linesTerminator, SqlCharStringLiteral nullAs, SqlCharStringLiteral serdeClass, SqlNodeList serdeProps) throws ParseException {
            this.pos = pos;
            if (fieldsTerminator != null) {
                this.delimitPropToValue.put(FIELD_DELIM, fieldsTerminator);
            }
            if (escape != null) {
                this.delimitPropToValue.put(ESCAPE_CHAR, escape);
            }
            if (collectionTerminator != null) {
                this.delimitPropToValue.put(COLLECTION_DELIM, collectionTerminator);
            }
            if (mapKeyTerminator != null) {
                this.delimitPropToValue.put(MAPKEY_DELIM, mapKeyTerminator);
            }
            if (linesTerminator != null) {
                this.delimitPropToValue.put(LINE_DELIM, linesTerminator);
            }
            if (nullAs != null) {
                this.delimitPropToValue.put(SERIALIZATION_NULL_FORMAT, nullAs);
            }
            this.serdeClass = serdeClass;
            this.serdeProps = serdeProps;
            this.validate();
        }

        private void validate() throws ParseException {
            if (!this.delimitPropToValue.isEmpty()) {
                if (this.serdeClass != null || this.serdeProps != null) {
                    throw new ParseException("Both DELIMITED and SERDE specified");
                }
            } else if (this.serdeClass == null) {
                throw new ParseException("Neither DELIMITED nor SERDE specified");
            }
        }

        public SqlNodeList toPropList() {
            SqlNodeList list = new SqlNodeList(this.pos);
            if (this.serdeClass != null) {
                list.add(HiveDDLUtils.toTableOption(SERDE_LIB_CLASS_NAME, this.serdeClass, this.pos));
                if (this.serdeProps != null) {
                    for (SqlNode sqlNode : this.serdeProps) {
                        SqlTableOption option = (SqlTableOption)sqlNode;
                        list.add(HiveDDLUtils.toTableOption(SERDE_INFO_PROP_PREFIX + option.getKeyString(), option.getValue(), this.pos));
                    }
                }
            } else {
                for (String prop : this.delimitPropToValue.keySet()) {
                    list.add(HiveDDLUtils.toTableOption(prop, this.delimitPropToValue.get(prop), this.pos));
                }
            }
            HiveDDLUtils.unescapeProperties(list);
            return list;
        }

        public static HiveTableRowFormat withDelimited(SqlParserPos pos, SqlCharStringLiteral fieldsTerminator, SqlCharStringLiteral escape, SqlCharStringLiteral collectionTerminator, SqlCharStringLiteral mapKeyTerminator, SqlCharStringLiteral linesTerminator, SqlCharStringLiteral nullAs) throws ParseException {
            return new HiveTableRowFormat(pos, fieldsTerminator, escape, collectionTerminator, mapKeyTerminator, linesTerminator, nullAs, null, null);
        }

        public static HiveTableRowFormat withSerDe(SqlParserPos pos, SqlCharStringLiteral serdeClass, SqlNodeList serdeProps) throws ParseException {
            return new HiveTableRowFormat(pos, null, null, null, null, null, null, serdeClass, serdeProps);
        }
    }

    public static class HiveTableStoredAs {
        public static final String STORED_AS_FILE_FORMAT = "hive.storage.file-format";
        public static final String STORED_AS_INPUT_FORMAT = "hive.stored.as.input.format";
        public static final String STORED_AS_OUTPUT_FORMAT = "hive.stored.as.output.format";
        private final SqlParserPos pos;
        private final SqlIdentifier fileFormat;
        private final SqlCharStringLiteral intputFormat;
        private final SqlCharStringLiteral outputFormat;

        private HiveTableStoredAs(SqlParserPos pos, SqlIdentifier fileFormat, SqlCharStringLiteral intputFormat, SqlCharStringLiteral outputFormat) throws ParseException {
            this.pos = pos;
            this.fileFormat = fileFormat;
            this.intputFormat = intputFormat;
            this.outputFormat = outputFormat;
            this.validate();
        }

        private void validate() throws ParseException {
            if (this.fileFormat != null) {
                if (this.intputFormat != null || this.outputFormat != null) {
                    throw new ParseException("Both file format and input/output format are specified");
                }
            } else if (this.intputFormat == null || this.outputFormat == null) {
                throw new ParseException("Neither file format nor input/output format is specified");
            }
        }

        public SqlNodeList toPropList() {
            SqlNodeList res = new SqlNodeList(this.pos);
            if (this.fileFormat != null) {
                res.add(HiveDDLUtils.toTableOption(STORED_AS_FILE_FORMAT, this.fileFormat.getSimple(), this.fileFormat.getParserPosition()));
            } else {
                res.add(HiveDDLUtils.toTableOption(STORED_AS_INPUT_FORMAT, this.intputFormat, this.intputFormat.getParserPosition()));
                res.add(HiveDDLUtils.toTableOption(STORED_AS_OUTPUT_FORMAT, this.outputFormat, this.outputFormat.getParserPosition()));
            }
            return res;
        }

        public static HiveTableStoredAs ofFileFormat(SqlParserPos pos, SqlIdentifier fileFormat) throws ParseException {
            return new HiveTableStoredAs(pos, fileFormat, null, null);
        }

        public static HiveTableStoredAs ofInputOutputFormat(SqlParserPos pos, SqlCharStringLiteral intputFormat, SqlCharStringLiteral outputFormat) throws ParseException {
            return new HiveTableStoredAs(pos, null, intputFormat, outputFormat);
        }
    }

    public static class HiveTableCreationContext
    extends SqlCreateTable.TableCreationContext {
        public SqlHiveConstraintTrait pkTrait = null;
        public List<SqlHiveConstraintTrait> notNullTraits = null;
        public List<SqlIdentifier> notNullCols = null;
    }
}

