/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.TimeString;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;

public class SqlTimeLiteral
extends SqlAbstractDateTimeLiteral {
    SqlTimeLiteral(TimeString t, int precision, boolean hasTimeZone, SqlParserPos pos) {
        super(t, hasTimeZone, SqlTypeName.TIME, precision, pos);
        Preconditions.checkArgument(this.precision >= 0);
    }

    protected TimeString getTime() {
        return (TimeString)this.value;
    }

    @Override
    public SqlTimeLiteral clone(SqlParserPos pos) {
        return new SqlTimeLiteral((TimeString)this.value, this.precision, this.hasTimeZone, pos);
    }

    @Override
    public String toString() {
        return "TIME '" + this.toFormattedString() + "'";
    }

    @Override
    public String toFormattedString() {
        return this.getTime().toString(this.precision);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.getDialect().unparseDateTimeLiteral(writer, this, leftPrec, rightPrec);
    }
}

