/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.externalize;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.externalize.RelWriterImpl;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.XmlOutput;

public class RelXmlWriter
extends RelWriterImpl {
    private final XmlOutput xmlOutput;
    boolean generic = true;

    public RelXmlWriter(PrintWriter pw, SqlExplainLevel detailLevel) {
        super(pw, detailLevel, true);
        this.xmlOutput = new XmlOutput(pw);
        this.xmlOutput.setGlob(true);
        this.xmlOutput.setCompact(false);
    }

    @Override
    protected void explain_(RelNode rel, List<Pair<String, Object>> values) {
        if (this.generic) {
            this.explainGeneric(rel, values);
        } else {
            this.explainSpecific(rel, values);
        }
    }

    private void explainGeneric(RelNode rel, List<Pair<String, Object>> values) {
        String relType = rel.getRelTypeName();
        this.xmlOutput.beginBeginTag("RelNode");
        this.xmlOutput.attribute("type", relType);
        this.xmlOutput.endBeginTag("RelNode");
        ArrayList<RelNode> inputs = new ArrayList<RelNode>();
        for (Pair<String, Object> pair : values) {
            if (pair.right instanceof RelNode) {
                inputs.add((RelNode)pair.right);
                continue;
            }
            if (pair.right == null) continue;
            this.xmlOutput.beginBeginTag("Property");
            this.xmlOutput.attribute("name", (String)pair.left);
            this.xmlOutput.endBeginTag("Property");
            this.xmlOutput.cdata(pair.right.toString());
            this.xmlOutput.endTag("Property");
        }
        this.xmlOutput.beginTag("Inputs", null);
        this.spacer.add(2);
        for (RelNode input : inputs) {
            input.explain(this);
        }
        this.spacer.subtract(2);
        this.xmlOutput.endTag("Inputs");
        this.xmlOutput.endTag("RelNode");
    }

    private void explainSpecific(RelNode rel, List<Pair<String, Object>> values) {
        String tagName = rel.getRelTypeName();
        this.xmlOutput.beginBeginTag(tagName);
        this.xmlOutput.attribute("id", rel.getId() + "");
        for (Pair<String, Object> value2 : values) {
            if (value2.right instanceof RelNode) continue;
            this.xmlOutput.attribute((String)value2.left, value2.right.toString());
        }
        this.xmlOutput.endBeginTag(tagName);
        this.spacer.add(2);
        for (RelNode input : rel.getInputs()) {
            input.explain(this);
        }
        this.spacer.subtract(2);
    }
}

