/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.externalize;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributions;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.externalize.RelEnumTypes;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.JsonBuilder;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class RelJson {
    private final Map<String, Constructor> constructorMap = new HashMap<String, Constructor>();
    private final JsonBuilder jsonBuilder;
    public static final List<String> PACKAGES = ImmutableList.of("org.apache.calcite.rel.", "org.apache.calcite.rel.core.", "org.apache.calcite.rel.logical.", "org.apache.calcite.adapter.jdbc.", "org.apache.calcite.adapter.jdbc.JdbcRules$");

    public RelJson(JsonBuilder jsonBuilder) {
        this.jsonBuilder = jsonBuilder;
    }

    public RelNode create(Map<String, Object> map2) {
        String type = (String)map2.get("type");
        Constructor constructor = this.getConstructor(type);
        try {
            return (RelNode)constructor.newInstance(map2);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("while invoking constructor for type '" + type + "'", e);
        }
    }

    public Constructor getConstructor(String type) {
        Constructor constructor = this.constructorMap.get(type);
        if (constructor == null) {
            Class clazz = this.typeNameToClass(type);
            try {
                constructor = clazz.getConstructor(RelInput.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("class does not have required constructor, " + clazz + "(RelInput)");
            }
            this.constructorMap.put(type, constructor);
        }
        return constructor;
    }

    public Class typeNameToClass(String type) {
        if (!type.contains(".")) {
            for (String package_ : PACKAGES) {
                try {
                    return Class.forName(package_ + type);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("unknown type " + type);
        }
    }

    public String classToTypeName(Class<? extends RelNode> class_) {
        String canonicalName = class_.getName();
        for (String package_ : PACKAGES) {
            String remaining;
            if (!canonicalName.startsWith(package_) || (remaining = canonicalName.substring(package_.length())).indexOf(46) >= 0 || remaining.indexOf(36) >= 0) continue;
            return remaining;
        }
        return canonicalName;
    }

    public Object toJson(RelCollationImpl node) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (RelFieldCollation fieldCollation : node.getFieldCollations()) {
            Map<String, Object> map2 = this.jsonBuilder.map();
            map2.put("field", fieldCollation.getFieldIndex());
            map2.put("direction", fieldCollation.getDirection().name());
            map2.put("nulls", fieldCollation.nullDirection.name());
            list.add(map2);
        }
        return list;
    }

    public RelCollation toCollation(List<Map<String, Object>> jsonFieldCollations) {
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
        for (Map<String, Object> map2 : jsonFieldCollations) {
            fieldCollations.add(this.toFieldCollation(map2));
        }
        return RelCollations.of(fieldCollations);
    }

    public RelFieldCollation toFieldCollation(Map<String, Object> map2) {
        Integer field = (Integer)map2.get("field");
        RelFieldCollation.Direction direction = (RelFieldCollation.Direction)((Object)Util.enumVal(RelFieldCollation.Direction.class, (String)map2.get("direction")));
        RelFieldCollation.NullDirection nullDirection = (RelFieldCollation.NullDirection)((Object)Util.enumVal(RelFieldCollation.NullDirection.class, (String)map2.get("nulls")));
        return new RelFieldCollation(field, direction, nullDirection);
    }

    public RelDistribution toDistribution(Map<String, Object> map2) {
        RelDistribution.Type type = (RelDistribution.Type)((Object)Util.enumVal(RelDistribution.Type.class, (String)map2.get("type")));
        ImmutableIntList list = RelDistributions.EMPTY;
        if (map2.containsKey("keys")) {
            List keys = (List)map2.get("keys");
            list = ImmutableIntList.copyOf(keys);
        }
        return RelDistributions.of(type, list);
    }

    private Object toJson(RelDistribution relDistribution) {
        Map<String, Object> map2 = this.jsonBuilder.map();
        map2.put("type", relDistribution.getType().name());
        if (!relDistribution.getKeys().isEmpty()) {
            map2.put("keys", relDistribution.getKeys());
        }
        return map2;
    }

    public RelDataType toType(RelDataTypeFactory typeFactory, Object o) {
        if (o instanceof List) {
            List jsonList = (List)o;
            RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
            for (Map jsonMap : jsonList) {
                ((RelDataTypeFactory.Builder)builder).add((String)jsonMap.get("name"), this.toType(typeFactory, jsonMap));
            }
            return builder.build();
        }
        if (o instanceof Map) {
            Map map2 = (Map)o;
            Object fields2 = map2.get("fields");
            if (fields2 != null) {
                return this.toType(typeFactory, fields2);
            }
            SqlTypeName sqlTypeName = (SqlTypeName)((Object)Util.enumVal(SqlTypeName.class, (String)map2.get("type")));
            Integer precision = (Integer)map2.get("precision");
            Integer scale = (Integer)map2.get("scale");
            if (SqlTypeName.INTERVAL_TYPES.contains((Object)sqlTypeName)) {
                TimeUnit startUnit = sqlTypeName.getStartUnit();
                TimeUnit endUnit = sqlTypeName.getEndUnit();
                return typeFactory.createSqlIntervalType(new SqlIntervalQualifier(startUnit, endUnit, SqlParserPos.ZERO));
            }
            RelDataType type = sqlTypeName == SqlTypeName.ARRAY ? typeFactory.createArrayType(typeFactory.createSqlType(SqlTypeName.ANY), -1L) : (precision == null ? typeFactory.createSqlType(sqlTypeName) : (scale == null ? typeFactory.createSqlType(sqlTypeName, precision) : typeFactory.createSqlType(sqlTypeName, precision, scale)));
            boolean nullable = (Boolean)map2.get("nullable");
            return typeFactory.createTypeWithNullability(type, nullable);
        }
        SqlTypeName sqlTypeName = (SqlTypeName)((Object)Util.enumVal(SqlTypeName.class, (String)o));
        return typeFactory.createSqlType(sqlTypeName);
    }

    public Object toJson(AggregateCall node) {
        Map<String, Object> map2 = this.jsonBuilder.map();
        Map aggMap = this.toJson(node.getAggregation());
        if (node.getAggregation().getFunctionType().isUserDefined()) {
            aggMap.put("class", node.getAggregation().getClass().getName());
        }
        map2.put("agg", aggMap);
        map2.put("type", this.toJson(node.getType()));
        map2.put("distinct", node.isDistinct());
        map2.put("operands", node.getArgList());
        map2.put("name", node.getName());
        return map2;
    }

    public Object toJson(Object value2) {
        if (value2 == null || value2 instanceof Number || value2 instanceof String || value2 instanceof Boolean) {
            return value2;
        }
        if (value2 instanceof RexNode) {
            return this.toJson((RexNode)value2);
        }
        if (value2 instanceof RexWindow) {
            return this.toJson((RexWindow)value2);
        }
        if (value2 instanceof RexFieldCollation) {
            return this.toJson((RexFieldCollation)value2);
        }
        if (value2 instanceof RexWindowBound) {
            return this.toJson((RexWindowBound)value2);
        }
        if (value2 instanceof CorrelationId) {
            return this.toJson((CorrelationId)value2);
        }
        if (value2 instanceof List) {
            List<Object> list = this.jsonBuilder.list();
            for (Object o : (List)value2) {
                list.add(this.toJson(o));
            }
            return list;
        }
        if (value2 instanceof ImmutableBitSet) {
            List<Object> list = this.jsonBuilder.list();
            for (Integer integer : (ImmutableBitSet)value2) {
                list.add(this.toJson(integer));
            }
            return list;
        }
        if (value2 instanceof AggregateCall) {
            return this.toJson((AggregateCall)value2);
        }
        if (value2 instanceof RelCollationImpl) {
            return this.toJson((RelCollationImpl)value2);
        }
        if (value2 instanceof RelDataType) {
            return this.toJson((RelDataType)value2);
        }
        if (value2 instanceof RelDataTypeField) {
            return this.toJson((RelDataTypeField)value2);
        }
        if (value2 instanceof RelDistribution) {
            return this.toJson((RelDistribution)value2);
        }
        throw new UnsupportedOperationException("type not serializable: " + value2 + " (type " + value2.getClass().getCanonicalName() + ")");
    }

    private Object toJson(RelDataType node) {
        if (node.isStruct()) {
            List<Object> list = this.jsonBuilder.list();
            for (RelDataTypeField field : node.getFieldList()) {
                list.add(this.toJson(field));
            }
            return list;
        }
        Map<String, Object> map2 = this.jsonBuilder.map();
        map2.put("type", node.getSqlTypeName().name());
        map2.put("nullable", node.isNullable());
        if (node.getSqlTypeName().allowsPrec()) {
            map2.put("precision", node.getPrecision());
        }
        if (node.getSqlTypeName().allowsScale()) {
            map2.put("scale", node.getScale());
        }
        return map2;
    }

    private Object toJson(RelDataTypeField node) {
        Map map2;
        if (node.getType().isStruct()) {
            map2 = this.jsonBuilder.map();
            map2.put("fields", this.toJson(node.getType()));
        } else {
            map2 = (Map)this.toJson(node.getType());
        }
        map2.put("name", node.getName());
        return map2;
    }

    private Object toJson(CorrelationId node) {
        return node.getId();
    }

    private Object toJson(RexNode node) {
        switch (node.getKind()) {
            case FIELD_ACCESS: {
                Map<String, Object> map2 = this.jsonBuilder.map();
                RexFieldAccess fieldAccess = (RexFieldAccess)node;
                map2.put("field", fieldAccess.getField().getName());
                map2.put("expr", this.toJson(fieldAccess.getReferenceExpr()));
                return map2;
            }
            case LITERAL: {
                RexLiteral literal = (RexLiteral)node;
                Object value2 = literal.getValue3();
                Map<String, Object> map3 = this.jsonBuilder.map();
                map3.put("literal", RelEnumTypes.fromEnum(value2));
                map3.put("type", this.toJson(node.getType()));
                return map3;
            }
            case INPUT_REF: {
                Map<String, Object> map4 = this.jsonBuilder.map();
                map4.put("input", ((RexSlot)node).getIndex());
                map4.put("name", ((RexSlot)node).getName());
                return map4;
            }
            case LOCAL_REF: {
                Map<String, Object> map5 = this.jsonBuilder.map();
                map5.put("input", ((RexSlot)node).getIndex());
                map5.put("name", ((RexSlot)node).getName());
                map5.put("type", this.toJson(node.getType()));
                return map5;
            }
            case CORREL_VARIABLE: {
                Map<String, Object> map6 = this.jsonBuilder.map();
                map6.put("correl", ((RexCorrelVariable)node).getName());
                map6.put("type", this.toJson(node.getType()));
                return map6;
            }
        }
        if (node instanceof RexCall) {
            RexCall call = (RexCall)node;
            Map<String, Object> map7 = this.jsonBuilder.map();
            map7.put("op", this.toJson(call.getOperator()));
            List<Object> list = this.jsonBuilder.list();
            for (RexNode operand : call.getOperands()) {
                list.add(this.toJson(operand));
            }
            map7.put("operands", list);
            switch (node.getKind()) {
                case CAST: {
                    map7.put("type", this.toJson(node.getType()));
                }
            }
            if (call.getOperator() instanceof SqlFunction && ((SqlFunction)call.getOperator()).getFunctionType().isUserDefined()) {
                SqlOperator op = call.getOperator();
                map7.put("class", op.getClass().getName());
                map7.put("type", this.toJson(node.getType()));
                map7.put("deterministic", op.isDeterministic());
                map7.put("dynamic", op.isDynamicFunction());
            }
            if (call instanceof RexOver) {
                RexOver over2 = (RexOver)call;
                map7.put("distinct", over2.isDistinct());
                map7.put("type", this.toJson(node.getType()));
                map7.put("window", this.toJson(over2.getWindow()));
            }
            return map7;
        }
        throw new UnsupportedOperationException("unknown rex " + node);
    }

    private Object toJson(RexWindow window) {
        Map<String, Object> map2 = this.jsonBuilder.map();
        if (window.partitionKeys.size() > 0) {
            map2.put("partition", this.toJson(window.partitionKeys));
        }
        if (window.orderKeys.size() > 0) {
            map2.put("order", this.toJson(window.orderKeys));
        }
        if (window.getLowerBound() != null) {
            if (window.getUpperBound() == null) {
                if (window.isRows()) {
                    map2.put("rows-lower", this.toJson(window.getLowerBound()));
                } else {
                    map2.put("range-lower", this.toJson(window.getLowerBound()));
                }
            } else if (window.isRows()) {
                map2.put("rows-lower", this.toJson(window.getLowerBound()));
                map2.put("rows-upper", this.toJson(window.getUpperBound()));
            } else {
                map2.put("range-lower", this.toJson(window.getLowerBound()));
                map2.put("range-upper", this.toJson(window.getUpperBound()));
            }
        }
        return map2;
    }

    private Object toJson(RexFieldCollation collation) {
        Map<String, Object> map2 = this.jsonBuilder.map();
        map2.put("expr", this.toJson((RexNode)collation.left));
        map2.put("direction", collation.getDirection().name());
        map2.put("null-direction", collation.getNullDirection().name());
        return map2;
    }

    private Object toJson(RexWindowBound windowBound) {
        Map<String, Object> map2 = this.jsonBuilder.map();
        if (windowBound.isCurrentRow()) {
            map2.put("type", "CURRENT_ROW");
        } else if (windowBound.isUnbounded()) {
            map2.put("type", windowBound.isPreceding() ? "UNBOUNDED_PRECEDING" : "UNBOUNDED_FOLLOWING");
        } else {
            map2.put("type", windowBound.isPreceding() ? "PRECEDING" : "FOLLOWING");
            map2.put("offset", this.toJson(windowBound.getOffset()));
        }
        return map2;
    }

    RexNode toRex(RelInput relInput, Object o) {
        RelOptCluster cluster = relInput.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            Map map2 = (Map)o;
            Map opMap = (Map)map2.get("op");
            RelDataTypeFactory typeFactory = cluster.getTypeFactory();
            if (opMap != null) {
                if (map2.containsKey("class")) {
                    opMap.put("class", map2.get("class"));
                }
                List operands = (List)map2.get("operands");
                List<RexNode> rexOperands = this.toRexList(relInput, operands);
                Object jsonType = map2.get("type");
                Map window = (Map)map2.get("window");
                if (window != null) {
                    boolean physical;
                    RexWindowBound upperBound;
                    RexWindowBound lowerBound;
                    SqlAggFunction operator = this.toAggregation(opMap);
                    RelDataType type = this.toType(typeFactory, jsonType);
                    ArrayList<RexNode> partitionKeys = new ArrayList();
                    if (window.containsKey("partition")) {
                        partitionKeys = this.toRexList(relInput, (List)window.get("partition"));
                    }
                    List<Object> orderKeys = new ArrayList();
                    if (window.containsKey("order")) {
                        orderKeys = this.toRexFieldCollationList(relInput, (List)window.get("order"));
                    }
                    if (window.get("rows-lower") != null) {
                        lowerBound = this.toRexWindowBound(relInput, (Map)window.get("rows-lower"));
                        upperBound = this.toRexWindowBound(relInput, (Map)window.get("rows-upper"));
                        physical = true;
                    } else if (window.get("range-lower") != null) {
                        lowerBound = this.toRexWindowBound(relInput, (Map)window.get("range-lower"));
                        upperBound = this.toRexWindowBound(relInput, (Map)window.get("range-upper"));
                        physical = false;
                    } else {
                        lowerBound = null;
                        upperBound = null;
                        physical = false;
                    }
                    boolean distinct = (Boolean)map2.get("distinct");
                    return rexBuilder.makeOver(type, operator, rexOperands, partitionKeys, ImmutableList.copyOf(orderKeys), lowerBound, upperBound, physical, true, false, distinct, false);
                }
                SqlOperator operator = this.toOp(opMap);
                RelDataType type = jsonType != null ? this.toType(typeFactory, jsonType) : rexBuilder.deriveReturnType(operator, rexOperands);
                return rexBuilder.makeCall(type, operator, rexOperands);
            }
            Integer input = (Integer)map2.get("input");
            if (input != null) {
                if (map2.containsKey("type")) {
                    RelDataType type = this.toType(typeFactory, map2.get("type"));
                    return rexBuilder.makeLocalRef(type, input);
                }
                List<RelNode> inputNodes = relInput.getInputs();
                int i = input;
                for (RelNode inputNode : inputNodes) {
                    RelDataType rowType = inputNode.getRowType();
                    if (i < rowType.getFieldCount()) {
                        RelDataTypeField field = rowType.getFieldList().get(i);
                        return rexBuilder.makeInputRef(field.getType(), (int)input);
                    }
                    i -= rowType.getFieldCount();
                }
                throw new RuntimeException("input field " + input + " is out of range");
            }
            String field = (String)map2.get("field");
            if (field != null) {
                Object jsonExpr = map2.get("expr");
                RexNode expr = this.toRex(relInput, jsonExpr);
                return rexBuilder.makeFieldAccess(expr, field, true);
            }
            String correl = (String)map2.get("correl");
            if (correl != null) {
                Object jsonType = map2.get("type");
                RelDataType type = this.toType(typeFactory, jsonType);
                return rexBuilder.makeCorrel(type, new CorrelationId(correl));
            }
            if (map2.containsKey("literal")) {
                Object literal = map2.get("literal");
                RelDataType type = this.toType(typeFactory, map2.get("type"));
                if (literal == null) {
                    return rexBuilder.makeNullLiteral(type);
                }
                if (type == null) {
                    return this.toRex(relInput, literal);
                }
                if (type.getSqlTypeName() == SqlTypeName.SYMBOL) {
                    literal = RelEnumTypes.toEnum((String)literal);
                }
                return rexBuilder.makeLiteral(literal, type, false);
            }
            throw new UnsupportedOperationException("cannot convert to rex " + o);
        }
        if (o instanceof Boolean) {
            return rexBuilder.makeLiteral((Boolean)o);
        }
        if (o instanceof String) {
            return rexBuilder.makeLiteral((String)o);
        }
        if (o instanceof Number) {
            Number number2 = (Number)o;
            if (number2 instanceof Double || number2 instanceof Float) {
                return rexBuilder.makeApproxLiteral(BigDecimal.valueOf(number2.doubleValue()));
            }
            return rexBuilder.makeExactLiteral(BigDecimal.valueOf(number2.longValue()));
        }
        throw new UnsupportedOperationException("cannot convert to rex " + o);
    }

    private List<RexFieldCollation> toRexFieldCollationList(RelInput relInput, List<Map<String, Object>> order) {
        if (order == null) {
            return null;
        }
        ArrayList<RexFieldCollation> list = new ArrayList<RexFieldCollation>();
        for (Map<String, Object> o : order) {
            RexNode expr = this.toRex(relInput, o.get("expr"));
            HashSet<SqlKind> directions = new HashSet<SqlKind>();
            if (RelFieldCollation.Direction.valueOf((String)o.get("direction")) == RelFieldCollation.Direction.DESCENDING) {
                directions.add(SqlKind.DESCENDING);
            }
            if (RelFieldCollation.NullDirection.valueOf((String)o.get("null-direction")) == RelFieldCollation.NullDirection.FIRST) {
                directions.add(SqlKind.NULLS_FIRST);
            } else {
                directions.add(SqlKind.NULLS_LAST);
            }
            list.add(new RexFieldCollation(expr, (Set<SqlKind>)directions));
        }
        return list;
    }

    private RexWindowBound toRexWindowBound(RelInput input, Map<String, Object> map2) {
        if (map2 == null) {
            return null;
        }
        String type = (String)map2.get("type");
        RexBuilder rexBuilder = input.getCluster().getRexBuilder();
        switch (type) {
            case "CURRENT_ROW": {
                return RexWindowBounds.CURRENT_ROW;
            }
            case "UNBOUNDED_PRECEDING": {
                return RexWindowBounds.UNBOUNDED_PRECEDING;
            }
            case "UNBOUNDED_FOLLOWING": {
                return RexWindowBounds.UNBOUNDED_FOLLOWING;
            }
            case "PRECEDING": {
                return RexWindowBounds.preceding(this.toRex(input, map2.get("offset")));
            }
            case "FOLLOWING": {
                return RexWindowBounds.following(this.toRex(input, map2.get("offset")));
            }
        }
        throw new UnsupportedOperationException("cannot convert type to rex window bound " + type);
    }

    private List<RexNode> toRexList(RelInput relInput, List operands) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        for (Object operand : operands) {
            list.add(this.toRex(relInput, operand));
        }
        return list;
    }

    SqlOperator toOp(Map<String, Object> map2) {
        String name = map2.get("name").toString();
        String kind = map2.get("kind").toString();
        String syntax = map2.get("syntax").toString();
        SqlKind sqlKind = SqlKind.valueOf(kind);
        SqlSyntax sqlSyntax = SqlSyntax.valueOf(syntax);
        ArrayList<SqlOperator> operators = new ArrayList<SqlOperator>();
        SqlStdOperatorTable.instance().lookupOperatorOverloads(new SqlIdentifier(name, new SqlParserPos(0, 0)), null, sqlSyntax, operators, SqlNameMatchers.liberal());
        for (SqlOperator operator : operators) {
            if (operator.kind != sqlKind) continue;
            return operator;
        }
        String class_ = (String)map2.get("class");
        if (class_ != null) {
            return AvaticaUtils.instantiatePlugin(SqlOperator.class, class_);
        }
        return null;
    }

    SqlAggFunction toAggregation(Map<String, Object> map2) {
        return (SqlAggFunction)this.toOp(map2);
    }

    private Map toJson(SqlOperator operator) {
        Map<String, Object> map2 = this.jsonBuilder.map();
        map2.put("name", operator.getName());
        map2.put("kind", operator.kind.toString());
        map2.put("syntax", operator.getSyntax().toString());
        return map2;
    }
}

