/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexChecker;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSet;
import org.apiguardian.api.API;

public abstract class Join
extends BiRel
implements Hintable {
    protected final RexNode condition;
    protected final ImmutableSet<CorrelationId> variablesSet;
    protected final ImmutableList<RelHint> hints;
    protected final JoinRelType joinType;
    protected final JoinInfo joinInfo;

    protected Join(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        super(cluster, traitSet, left, right);
        this.condition = Objects.requireNonNull(condition);
        this.variablesSet = ImmutableSet.copyOf(variablesSet);
        this.joinType = Objects.requireNonNull(joinType);
        this.joinInfo = JoinInfo.of(left, right, condition);
        this.hints = ImmutableList.copyOf(hints);
    }

    @Deprecated
    protected Join(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        this(cluster, traitSet, ImmutableList.of(), left, right, condition, variablesSet, joinType);
    }

    @Deprecated
    protected Join(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) {
        this(cluster, traitSet, ImmutableList.of(), left, right, condition, CorrelationId.setOf(variablesStopped), joinType);
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        RexNode condition = shuttle.apply(this.condition);
        if (this.condition == condition) {
            return this;
        }
        return this.copy(this.traitSet, condition, this.left, this.right, this.joinType, this.isSemiJoinDone());
    }

    public RexNode getCondition() {
        return this.condition;
    }

    public JoinRelType getJoinType() {
        return this.joinType;
    }

    @Override
    public boolean isValid(Litmus litmus, RelNode.Context context) {
        if (!super.isValid(litmus, context)) {
            return false;
        }
        if (this.getRowType().getFieldCount() != this.getSystemFieldList().size() + this.left.getRowType().getFieldCount() + (this.joinType.projectsRight() ? this.right.getRowType().getFieldCount() : 0)) {
            return litmus.fail("field count mismatch", new Object[0]);
        }
        if (this.condition != null) {
            if (this.condition.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
                return litmus.fail("condition must be boolean: {}", this.condition.getType());
            }
            RexChecker checker = new RexChecker(((RelDataTypeFactory.FieldInfoBuilder)((RelDataTypeFactory.FieldInfoBuilder)this.getCluster().getTypeFactory().builder().addAll(this.getSystemFieldList())).addAll(this.getLeft().getRowType().getFieldList())).addAll(this.getRight().getRowType().getFieldList()).build(), context, litmus);
            this.condition.accept(checker);
            if (checker.getFailureCount() > 0) {
                return litmus.fail(checker.getFailureCount() + " failures in condition " + this.condition, new Object[0]);
            }
        }
        return litmus.succeed();
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (this.isSemiJoin()) {
            return planner.getCostFactory().makeTinyCost();
        }
        double rowCount = mq.getRowCount(this);
        return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
    }

    @Deprecated
    public static double estimateJoinedRows(Join joinRel, RexNode condition) {
        RelMetadataQuery mq = joinRel.getCluster().getMetadataQuery();
        return Util.first(RelMdUtil.getJoinRowCount(mq, joinRel, condition), 1.0);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return Util.first(RelMdUtil.getJoinRowCount(mq, this, this.condition), 1.0);
    }

    @Override
    public Set<CorrelationId> getVariablesSet() {
        return this.variablesSet;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("condition", this.condition).item("joinType", this.joinType.lowerName).itemIf("systemFields", this.getSystemFieldList(), !this.getSystemFieldList().isEmpty());
    }

    @API(since="1.24", status=API.Status.INTERNAL)
    protected boolean deepEquals0(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Join o = (Join)obj;
        return this.traitSet.equals(o.traitSet) && this.left.deepEquals(o.left) && this.right.deepEquals(o.right) && this.condition.equals(o.condition) && this.joinType == o.joinType && this.hints.equals(o.hints) && this.getRowType().equalsSansFieldNames(o.getRowType());
    }

    @API(since="1.24", status=API.Status.INTERNAL)
    protected int deepHashCode0() {
        return Objects.hash(new Object[]{this.traitSet, this.left.deepHashCode(), this.right.deepHashCode(), this.condition, this.joinType, this.hints});
    }

    @Override
    protected RelDataType deriveRowType() {
        return SqlValidatorUtil.deriveJoinRowType(this.left.getRowType(), this.right.getRowType(), this.joinType, this.getCluster().getTypeFactory(), null, this.getSystemFieldList());
    }

    public boolean isSemiJoinDone() {
        return false;
    }

    public boolean isSemiJoin() {
        return this.joinType == JoinRelType.SEMI;
    }

    public List<RelDataTypeField> getSystemFieldList() {
        return Collections.emptyList();
    }

    @Deprecated
    public static RelDataType deriveJoinRowType(RelDataType leftType, RelDataType rightType, JoinRelType joinType, RelDataTypeFactory typeFactory, List<String> fieldNameList, List<RelDataTypeField> systemFieldList) {
        return SqlValidatorUtil.deriveJoinRowType(leftType, rightType, joinType, typeFactory, fieldNameList, systemFieldList);
    }

    @Deprecated
    public static RelDataType createJoinType(RelDataTypeFactory typeFactory, RelDataType leftType, RelDataType rightType, List<String> fieldNameList, List<RelDataTypeField> systemFieldList) {
        return SqlValidatorUtil.createJoinType(typeFactory, leftType, rightType, fieldNameList, systemFieldList);
    }

    @Override
    public final Join copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.size() == 2);
        return this.copy(traitSet, this.getCondition(), inputs.get(0), inputs.get(1), this.joinType, this.isSemiJoinDone());
    }

    public abstract Join copy(RelTraitSet var1, RexNode var2, RelNode var3, RelNode var4, JoinRelType var5, boolean var6);

    public JoinInfo analyzeCondition() {
        return this.joinInfo;
    }

    @Override
    public ImmutableList<RelHint> getHints() {
        return this.hints;
    }
}

