/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry.ogc;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OGCStructureInternal;
import com.esri.core.geometry.OperatorConvexHull;
import com.esri.core.geometry.OperatorDifference;
import com.esri.core.geometry.OperatorExportToGeoJson;
import com.esri.core.geometry.OperatorIntersection;
import com.esri.core.geometry.OperatorUnion;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.SimpleGeometryCursor;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCGeometryCollection;
import com.esri.core.geometry.ogc.OGCMultiLineString;
import com.esri.core.geometry.ogc.OGCMultiPoint;
import com.esri.core.geometry.ogc.OGCMultiPolygon;
import com.esri.core.geometry.ogc.OGCPoint;
import com.esri.core.geometry.ogc.OGCPolygon;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class OGCConcreteGeometryCollection
extends OGCGeometryCollection {
    public static String TYPE = "GeometryCollection";
    List<OGCGeometry> geometries;

    public OGCConcreteGeometryCollection(List<OGCGeometry> geoms, SpatialReference sr) {
        this.geometries = geoms;
        this.esriSR = sr;
    }

    public OGCConcreteGeometryCollection(GeometryCursor geoms, SpatialReference sr) {
        ArrayList<OGCGeometry> ogcGeoms = new ArrayList<OGCGeometry>(10);
        Geometry g = geoms.next();
        while (g != null) {
            ogcGeoms.add(OGCConcreteGeometryCollection.createFromEsriGeometry(g, sr));
            g = geoms.next();
        }
        this.geometries = ogcGeoms;
        this.esriSR = sr;
    }

    public OGCConcreteGeometryCollection(OGCGeometry geom, SpatialReference sr) {
        this.geometries = new ArrayList<OGCGeometry>(1);
        this.geometries.add(geom);
        this.esriSR = sr;
    }

    public OGCConcreteGeometryCollection(SpatialReference sr) {
        this.geometries = new ArrayList<OGCGeometry>();
        this.esriSR = sr;
    }

    @Override
    public int dimension() {
        int maxD = 0;
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            maxD = Math.max(this.geometryN(i).dimension(), maxD);
        }
        return maxD;
    }

    @Override
    public int coordinateDimension() {
        return this.isEmpty() ? 2 : this.geometryN(0).coordinateDimension();
    }

    @Override
    public boolean is3D() {
        return !this.isEmpty() && this.geometries.get(0).is3D();
    }

    @Override
    public boolean isMeasured() {
        return !this.isEmpty() && this.geometries.get(0).isMeasured();
    }

    @Override
    public OGCGeometry envelope() {
        GeometryCursor gc = this.getEsriGeometryCursor();
        Envelope env = new Envelope();
        Geometry g = gc.next();
        while (g != null) {
            Envelope e = new Envelope();
            g.queryEnvelope(e);
            env.merge(e);
            g = gc.next();
        }
        Polygon polygon = new Polygon();
        polygon.addEnvelope(env, false);
        return new OGCPolygon(polygon, this.esriSR);
    }

    @Override
    public int numGeometries() {
        return this.geometries.size();
    }

    @Override
    public OGCGeometry geometryN(int n) {
        return this.geometries.get(n);
    }

    @Override
    public String geometryType() {
        return TYPE;
    }

    @Override
    public long estimateMemorySize() {
        long size = 24L;
        if (this.geometries != null) {
            for (OGCGeometry geometry : this.geometries) {
                size += geometry.estimateMemorySize();
            }
        }
        return size;
    }

    @Override
    public String asText() {
        int n;
        StringBuilder sb = new StringBuilder("GEOMETRYCOLLECTION ");
        if (this.is3D()) {
            sb.append('Z');
        }
        if (this.isMeasured()) {
            sb.append('M');
        }
        if (this.is3D() || this.isMeasured()) {
            sb.append(' ');
        }
        if ((n = this.numGeometries()) == 0) {
            sb.append("EMPTY");
            return sb.toString();
        }
        sb.append('(');
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.geometryN(i).asText());
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public ByteBuffer asBinary() {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(0);
        int size = 9;
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            ByteBuffer buffer = this.geometryN(i).asBinary();
            buffers.add(buffer);
            size += buffer.capacity();
        }
        ByteBuffer wkbBuffer = ByteBuffer.allocate(size).order(ByteOrder.nativeOrder());
        byte byteOrder = (byte)(wkbBuffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0);
        int wkbType = 7;
        if (this.is3D()) {
            wkbType += 1000;
        }
        if (this.isMeasured()) {
            wkbType += 2000;
        }
        wkbBuffer.put(0, byteOrder);
        wkbBuffer.putInt(1, wkbType);
        wkbBuffer.putInt(5, n);
        int offset = 9;
        for (int i = 0; i < n; ++i) {
            byte[] arr = ((ByteBuffer)buffers.get(i)).array();
            System.arraycopy(arr, 0, wkbBuffer.array(), offset, arr.length);
            offset += arr.length;
        }
        return wkbBuffer;
    }

    @Override
    public String asGeoJson() {
        return this.asGeoJsonImpl(0);
    }

    @Override
    String asGeoJsonImpl(int export_flags) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"type\":\"GeometryCollection\",\"geometries\":");
        sb.append("[");
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            if (this.geometryN(i) == null) continue;
            sb.append(this.geometryN(i).asGeoJsonImpl(8));
        }
        sb.append("],\"crs\":");
        if (this.esriSR != null) {
            String crs_value = OperatorExportToGeoJson.local().exportSpatialReference(0, this.esriSR);
            sb.append(crs_value);
        } else {
            sb.append("\"null\"");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.numGeometries() == 0;
    }

    @Override
    public double MinZ() {
        double z = Double.NaN;
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            z = i == 0 ? this.geometryN(i).MinZ() : Math.min(this.geometryN(i).MinZ(), z);
        }
        return z;
    }

    @Override
    public double MaxZ() {
        double z = Double.NaN;
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            z = i == 0 ? this.geometryN(i).MaxZ() : Math.min(this.geometryN(i).MaxZ(), z);
        }
        return z;
    }

    @Override
    public double MinMeasure() {
        double z = Double.NaN;
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            z = i == 0 ? this.geometryN(i).MinMeasure() : Math.min(this.geometryN(i).MinMeasure(), z);
        }
        return z;
    }

    @Override
    public double MaxMeasure() {
        double z = Double.NaN;
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            z = i == 0 ? this.geometryN(i).MaxMeasure() : Math.min(this.geometryN(i).MaxMeasure(), z);
        }
        return z;
    }

    @Override
    public boolean isSimple() {
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            if (this.geometryN(i).isSimple()) continue;
            return false;
        }
        return true;
    }

    @Override
    public OGCGeometry makeSimple() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSimpleRelaxed() {
        int n = this.numGeometries();
        for (int i = 0; i < n; ++i) {
            if (this.geometryN(i).isSimpleRelaxed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public OGCGeometry makeSimpleRelaxed(boolean forceProcessing) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry boundary() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return null;
    }

    @Override
    public GeometryCursor getEsriGeometryCursor() {
        return new GeometryCursorOGC(this.geometries);
    }

    @Override
    protected boolean isConcreteGeometryCollection() {
        return true;
    }

    @Override
    public OGCGeometry convexHull() {
        GeometryCursor cursor = OperatorConvexHull.local().execute(this.getEsriGeometryCursor(), false, null);
        MultiPoint mp = new MultiPoint();
        Polygon polygon = new Polygon();
        VertexDescription vd = null;
        Geometry geom = cursor.next();
        while (geom != null) {
            vd = geom.getDescription();
            if (!geom.isEmpty()) {
                if (geom.getType() == Geometry.Type.Polygon) {
                    polygon.add((MultiPath)geom, false);
                } else if (geom.getType() == Geometry.Type.Polyline) {
                    mp.add((MultiVertexGeometry)geom, 0, -1);
                } else if (geom.getType() == Geometry.Type.Point) {
                    mp.add((Point)geom);
                } else {
                    throw new GeometryException("internal error");
                }
            }
            geom = cursor.next();
        }
        Geometry resultGeom = null;
        if (!mp.isEmpty()) {
            resultGeom = OperatorConvexHull.local().execute(mp, null);
        }
        if (!polygon.isEmpty()) {
            if (!resultGeom.isEmpty()) {
                Geometry[] geoms = new Geometry[]{resultGeom, polygon};
                resultGeom = OperatorConvexHull.local().execute(new SimpleGeometryCursor(geoms), true, null).next();
            } else {
                resultGeom = polygon;
            }
        }
        if (resultGeom == null) {
            Point pt = new Point();
            if (vd != null) {
                pt.assignVertexDescription(vd);
            }
            return new OGCPoint(pt, this.getEsriSpatialReference());
        }
        return OGCGeometry.createFromEsriGeometry(resultGeom, this.getEsriSpatialReference(), false);
    }

    @Override
    public void setSpatialReference(SpatialReference esriSR_) {
        this.esriSR = esriSR_;
        int n = this.geometries.size();
        for (int i = 0; i < n; ++i) {
            if (this.geometries.get(i) == null) continue;
            this.geometries.get(i).setSpatialReference(esriSR_);
        }
    }

    @Override
    public OGCGeometry convertToMulti() {
        return this;
    }

    @Override
    public OGCGeometry reduceFromMulti() {
        int n = this.numGeometries();
        if (n == 0) {
            return this;
        }
        if (n == 1) {
            return this.geometryN(0).reduceFromMulti();
        }
        return this;
    }

    @Override
    public String asJson() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        OGCConcreteGeometryCollection another = (OGCConcreteGeometryCollection)other;
        if (this.geometries != null ? !this.geometries.equals(another.geometries) : another.geometries != null) {
            return false;
        }
        if (this.esriSR == another.esriSR) {
            return true;
        }
        if (this.esriSR != null && another.esriSR != null) {
            return this.esriSR.equals(another.esriSR);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash2 = 1;
        if (this.geometries != null) {
            hash2 = this.geometries.hashCode();
        }
        if (this.esriSR != null) {
            hash2 = NumberUtils.hashCombine(hash2, this.esriSR.hashCode());
        }
        return hash2;
    }

    @Override
    public double distance(OGCGeometry another) {
        double d;
        if (this == another) {
            return this.isEmpty() ? Double.NaN : 0.0;
        }
        double minD = Double.NaN;
        int n = this.numGeometries();
        for (int i = 0; i < n && (!((d = this.geometryN(i).distance(another)) < minD) && !Double.isNaN(minD) || (minD = d) != 0.0); ++i) {
        }
        return minD;
    }

    @Override
    public boolean overlaps(OGCGeometry another) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean touches(OGCGeometry another) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean crosses(OGCGeometry another) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean relate(OGCGeometry another, String matrix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean disjoint(OGCGeometry another) {
        if (this.isEmpty() || another.isEmpty()) {
            return true;
        }
        if (this == another) {
            return false;
        }
        OGCConcreteGeometryCollection flattened1 = this.flatten();
        if (flattened1.isEmpty()) {
            return true;
        }
        OGCConcreteGeometryCollection otherCol = new OGCConcreteGeometryCollection(another, this.esriSR);
        OGCConcreteGeometryCollection flattened2 = otherCol.flatten();
        if (flattened2.isEmpty()) {
            return true;
        }
        int n1 = flattened1.numGeometries();
        for (int i = 0; i < n1; ++i) {
            OGCGeometry g1 = flattened1.geometryN(i);
            int n2 = flattened2.numGeometries();
            for (int j2 = 0; j2 < n2; ++j2) {
                OGCGeometry g2 = flattened2.geometryN(j2);
                if (g1.disjoint(g2)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean contains(OGCGeometry another) {
        if (this.isEmpty() || another.isEmpty()) {
            return false;
        }
        if (this == another) {
            return true;
        }
        return another.difference(this).isEmpty();
    }

    @Override
    public boolean Equals(OGCGeometry another) {
        OGCGeometry g2;
        if (this == another) {
            return !this.isEmpty();
        }
        if (another == null) {
            return false;
        }
        OGCGeometry g1 = this.reduceFromMulti();
        String t1 = g1.geometryType();
        if (t1 != (g2 = this.reduceFromMulti()).geometryType()) {
            return false;
        }
        if (t1 != TYPE) {
            return g1.Equals(g2);
        }
        OGCConcreteGeometryCollection gc1 = (OGCConcreteGeometryCollection)g1;
        OGCConcreteGeometryCollection gc2 = (OGCConcreteGeometryCollection)g2;
        gc1 = gc1.flattenAndRemoveOverlaps();
        gc2 = gc2.flattenAndRemoveOverlaps();
        int n = gc1.numGeometries();
        if (n != gc2.numGeometries()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (gc1.geometryN(i).Equals(gc2.geometryN(i))) continue;
            return false;
        }
        return n > 0;
    }

    private static OGCConcreteGeometryCollection toGeometryCollection(OGCGeometry geometry) {
        if (geometry.geometryType() != TYPE) {
            return new OGCConcreteGeometryCollection(geometry, geometry.getEsriSpatialReference());
        }
        return (OGCConcreteGeometryCollection)geometry;
    }

    private static List<Geometry> toList(GeometryCursor cursor) {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        Geometry geometry = cursor.next();
        while (geometry != null) {
            geometries.add(geometry);
            geometry = cursor.next();
        }
        return geometries;
    }

    @Override
    public OGCGeometry difference(OGCGeometry another) {
        if (this.isEmpty() || another.isEmpty()) {
            return this;
        }
        List<Geometry> geometries = OGCConcreteGeometryCollection.toList(this.prepare_for_ops_(OGCConcreteGeometryCollection.toGeometryCollection(this)));
        List<Geometry> otherGeometries = OGCConcreteGeometryCollection.toList(this.prepare_for_ops_(OGCConcreteGeometryCollection.toGeometryCollection(another)));
        ArrayList<OGCGeometry> result = new ArrayList<OGCGeometry>();
        for (Geometry geometry : geometries) {
            for (Geometry otherGeometry : otherGeometries) {
                if (geometry.getDimension() > otherGeometry.getDimension() || !(geometry = OperatorDifference.local().execute(geometry, otherGeometry, this.esriSR, null)).isEmpty()) continue;
                break;
            }
            if (geometry.isEmpty()) continue;
            result.add(OGCGeometry.createFromEsriGeometry(geometry, this.esriSR));
        }
        if (result.size() == 1) {
            return ((OGCGeometry)result.get(0)).reduceFromMulti();
        }
        return new OGCConcreteGeometryCollection(result, this.esriSR).flattenAndRemoveOverlaps();
    }

    @Override
    public OGCGeometry intersection(OGCGeometry another) {
        if (this.isEmpty() || another.isEmpty()) {
            return new OGCConcreteGeometryCollection(this.esriSR);
        }
        List<Geometry> geometries = OGCConcreteGeometryCollection.toList(this.prepare_for_ops_(OGCConcreteGeometryCollection.toGeometryCollection(this)));
        List<Geometry> otherGeometries = OGCConcreteGeometryCollection.toList(this.prepare_for_ops_(OGCConcreteGeometryCollection.toGeometryCollection(another)));
        ArrayList<OGCGeometry> result = new ArrayList<OGCGeometry>();
        for (Geometry geometry : geometries) {
            for (Geometry otherGeometry : otherGeometries) {
                GeometryCursor intersectionCursor = OperatorIntersection.local().execute(new SimpleGeometryCursor(geometry), new SimpleGeometryCursor(otherGeometry), this.esriSR, null, 7);
                OGCGeometry intersection = OGCGeometry.createFromEsriCursor(intersectionCursor, this.esriSR, true);
                if (intersection.isEmpty()) continue;
                result.add(intersection);
            }
        }
        if (result.size() == 1) {
            return ((OGCGeometry)result.get(0)).reduceFromMulti();
        }
        return new OGCConcreteGeometryCollection(result, this.esriSR).flattenAndRemoveOverlaps();
    }

    @Override
    public OGCGeometry symDifference(OGCGeometry another) {
        throw new UnsupportedOperationException();
    }

    public boolean isFlattened() {
        int n = this.numGeometries();
        if (n > 3) {
            return false;
        }
        int dimension = -1;
        for (int i = 0; i < n; ++i) {
            OGCGeometry g = this.geometryN(i);
            if (g.isEmpty()) {
                return false;
            }
            String t = g.geometryType();
            if (t != OGCMultiPoint.TYPE && t != OGCMultiPolygon.TYPE && t != OGCMultiLineString.TYPE) {
                return false;
            }
            int d = g.dimension();
            if (d <= dimension) {
                return false;
            }
            dimension = d;
        }
        return true;
    }

    public OGCConcreteGeometryCollection flatten() {
        GeometryCursor unionedPolygons;
        Geometry g;
        if (this.isFlattened()) {
            return this;
        }
        OGCMultiPoint multiPoint = null;
        ArrayList<Geometry> polygons = null;
        OGCMultiLineString polyline = null;
        GeometryCursor gc = this.getEsriGeometryCursor();
        Geometry g2 = gc.next();
        while (g2 != null) {
            if (!g2.isEmpty()) {
                Geometry.Type t = g2.getType();
                if (t == Geometry.Type.Point) {
                    if (multiPoint == null) {
                        multiPoint = new OGCMultiPoint(this.esriSR);
                    }
                    ((MultiPoint)multiPoint.getEsriGeometry()).add((Point)g2);
                } else if (t == Geometry.Type.MultiPoint) {
                    if (multiPoint == null) {
                        multiPoint = new OGCMultiPoint(this.esriSR);
                    }
                    ((MultiPoint)multiPoint.getEsriGeometry()).add((MultiPoint)g2, 0, -1);
                } else if (t == Geometry.Type.Polyline) {
                    if (polyline == null) {
                        polyline = new OGCMultiLineString(this.esriSR);
                    }
                    ((MultiPath)polyline.getEsriGeometry()).add((Polyline)g2, false);
                } else if (t == Geometry.Type.Polygon) {
                    if (polygons == null) {
                        polygons = new ArrayList<Geometry>();
                    }
                    polygons.add(g2);
                } else {
                    throw new GeometryException("internal error");
                }
            }
            g2 = gc.next();
        }
        ArrayList<OGCGeometry> list = new ArrayList<OGCGeometry>();
        if (multiPoint != null) {
            list.add(multiPoint);
        }
        if (polyline != null) {
            list.add(polyline);
        }
        if (polygons != null && !(g = (unionedPolygons = OperatorUnion.local().execute(new SimpleGeometryCursor(polygons), this.esriSR, null)).next()).isEmpty()) {
            list.add(new OGCMultiPolygon((Polygon)g, this.esriSR));
        }
        return new OGCConcreteGeometryCollection(list, this.esriSR);
    }

    public OGCConcreteGeometryCollection flattenAndRemoveOverlaps() {
        GeometryCursor cursor = OGCStructureInternal.prepare_for_ops_(this.flatten().getEsriGeometryCursor(), this.esriSR);
        return new OGCConcreteGeometryCollection(this.removeOverlapsHelper_(OGCConcreteGeometryCollection.toList(cursor)), this.esriSR);
    }

    private GeometryCursor removeOverlapsHelper_(List<Geometry> geoms) {
        ArrayList<Geometry> result = new ArrayList<Geometry>();
        for (int i = 0; i < geoms.size(); ++i) {
            Geometry current = geoms.get(i);
            if (current.isEmpty()) continue;
            for (int j2 = i + 1; j2 < geoms.size(); ++j2) {
                Geometry subG = geoms.get(j2);
                current = OperatorDifference.local().execute(current, subG, this.esriSR, null);
                if (current.isEmpty()) break;
            }
            if (current.isEmpty()) continue;
            result.add(current);
        }
        return new SimpleGeometryCursor(result);
    }

    private GeometryCursor prepare_for_ops_(OGCConcreteGeometryCollection collection) {
        assert (collection != null && !collection.isEmpty());
        GeometryCursor prepared = OGCStructureInternal.prepare_for_ops_(collection.flatten().getEsriGeometryCursor(), this.esriSR);
        return this.removeOverlapsHelper_(OGCConcreteGeometryCollection.toList(prepared));
    }

    private static class FlatteningCollectionCursor
    extends GeometryCursor {
        private List<OGCConcreteGeometryCollection> m_collections;
        private GeometryCursor m_current;
        private int m_index;

        FlatteningCollectionCursor(List<OGCConcreteGeometryCollection> collections) {
            this.m_collections = collections;
            this.m_index = -1;
            this.m_current = null;
        }

        @Override
        public Geometry next() {
            while (this.m_collections != null) {
                if (this.m_current != null) {
                    Geometry g = this.m_current.next();
                    if (g == null) {
                        this.m_current = null;
                        continue;
                    }
                    return g;
                }
                ++this.m_index;
                if (this.m_index < this.m_collections.size()) {
                    this.m_current = this.m_collections.get(this.m_index).flatten().getEsriGeometryCursor();
                    continue;
                }
                this.m_collections = null;
                this.m_index = -1;
            }
            return null;
        }

        @Override
        public int getGeometryID() {
            return this.m_index;
        }
    }

    private static class GeometryCursorOGC
    extends GeometryCursor {
        private int m_index;
        private int m_ind;
        private List<OGCGeometry> m_geoms;
        GeometryCursor m_curs;

        GeometryCursorOGC(List<OGCGeometry> geoms) {
            this.m_geoms = geoms;
            this.m_index = -1;
            this.m_curs = null;
            this.m_ind = 0;
        }

        @Override
        public Geometry next() {
            int i;
            do {
                if (this.m_curs != null) {
                    Geometry g = this.m_curs.next();
                    if (g != null) {
                        ++this.m_index;
                        return g;
                    }
                    this.m_curs = null;
                }
                if (this.m_ind < this.m_geoms.size()) continue;
                return null;
            } while (this.m_geoms.get(i = this.m_ind++) == null);
            if (!this.m_geoms.get(i).isConcreteGeometryCollection()) {
                ++this.m_index;
                return this.m_geoms.get(i).getEsriGeometry();
            }
            OGCConcreteGeometryCollection gc = (OGCConcreteGeometryCollection)this.m_geoms.get(i);
            this.m_curs = new GeometryCursorOGC(gc.geometries);
            return this.next();
        }

        @Override
        public int getGeometryID() {
            return this.m_index;
        }
    }
}

