/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.JsonGeometryException;
import com.esri.core.geometry.JsonReader;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.calcite.shaded.com.fasterxml.jackson.core.JsonToken;

public class JsonParserReader
implements JsonReader {
    private JsonParser m_jsonParser;

    public JsonParserReader(JsonParser jsonParser) {
        this.m_jsonParser = jsonParser;
    }

    public static JsonReader createFromString(String str) {
        try {
            JsonFactory factory = new JsonFactory();
            JsonParser jsonParser = factory.createParser(str);
            jsonParser.nextToken();
            return new JsonParserReader(jsonParser);
        }
        catch (Exception ex) {
            throw new JsonGeometryException(ex.getMessage());
        }
    }

    public static JsonReader createFromStringNNT(String str) {
        try {
            JsonFactory factory = new JsonFactory();
            JsonParser jsonParser = factory.createParser(str);
            return new JsonParserReader(jsonParser);
        }
        catch (Exception ex) {
            throw new JsonGeometryException(ex.getMessage());
        }
    }

    private static JsonReader.Token mapToken(JsonToken token2) {
        if (token2 == JsonToken.END_ARRAY) {
            return JsonReader.Token.END_ARRAY;
        }
        if (token2 == JsonToken.END_OBJECT) {
            return JsonReader.Token.END_OBJECT;
        }
        if (token2 == JsonToken.FIELD_NAME) {
            return JsonReader.Token.FIELD_NAME;
        }
        if (token2 == JsonToken.START_ARRAY) {
            return JsonReader.Token.START_ARRAY;
        }
        if (token2 == JsonToken.START_OBJECT) {
            return JsonReader.Token.START_OBJECT;
        }
        if (token2 == JsonToken.VALUE_FALSE) {
            return JsonReader.Token.VALUE_FALSE;
        }
        if (token2 == JsonToken.VALUE_NULL) {
            return JsonReader.Token.VALUE_NULL;
        }
        if (token2 == JsonToken.VALUE_NUMBER_FLOAT) {
            return JsonReader.Token.VALUE_NUMBER_FLOAT;
        }
        if (token2 == JsonToken.VALUE_NUMBER_INT) {
            return JsonReader.Token.VALUE_NUMBER_INT;
        }
        if (token2 == JsonToken.VALUE_STRING) {
            return JsonReader.Token.VALUE_STRING;
        }
        if (token2 == JsonToken.VALUE_TRUE) {
            return JsonReader.Token.VALUE_TRUE;
        }
        if (token2 == null) {
            return null;
        }
        throw new JsonGeometryException("unexpected token");
    }

    @Override
    public JsonReader.Token nextToken() throws JsonGeometryException {
        try {
            JsonToken token2 = this.m_jsonParser.nextToken();
            return JsonParserReader.mapToken(token2);
        }
        catch (Exception ex) {
            throw new JsonGeometryException(ex);
        }
    }

    @Override
    public JsonReader.Token currentToken() throws JsonGeometryException {
        try {
            return JsonParserReader.mapToken(this.m_jsonParser.getCurrentToken());
        }
        catch (Exception ex) {
            throw new JsonGeometryException(ex);
        }
    }

    @Override
    public void skipChildren() throws JsonGeometryException {
        try {
            this.m_jsonParser.skipChildren();
        }
        catch (Exception ex) {
            throw new JsonGeometryException(ex);
        }
    }

    @Override
    public String currentString() throws JsonGeometryException {
        try {
            return this.m_jsonParser.getText();
        }
        catch (Exception ex) {
            throw new JsonGeometryException(ex);
        }
    }

    @Override
    public double currentDoubleValue() throws JsonGeometryException {
        try {
            return this.m_jsonParser.getValueAsDouble();
        }
        catch (Exception ex) {
            throw new JsonGeometryException(ex);
        }
    }

    @Override
    public int currentIntValue() throws JsonGeometryException {
        try {
            return this.m_jsonParser.getValueAsInt();
        }
        catch (Exception ex) {
            throw new JsonGeometryException(ex);
        }
    }

    @Override
    public boolean currentBooleanValue() {
        JsonReader.Token t = this.currentToken();
        if (t == JsonReader.Token.VALUE_TRUE) {
            return true;
        }
        if (t == JsonReader.Token.VALUE_FALSE) {
            return false;
        }
        throw new JsonGeometryException("Not a boolean");
    }
}

