/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.DescriptorValidator;
import org.apache.flink.table.plan.stats.ColumnStats;

@Internal
public class StatisticsValidator
implements DescriptorValidator {
    public static final String STATISTICS_PROPERTY_VERSION = "statistics.property-version";
    public static final String STATISTICS_ROW_COUNT = "statistics.row-count";
    public static final String STATISTICS_COLUMNS = "statistics.columns";
    public static final String NAME = "name";
    public static final String DISTINCT_COUNT = "distinct-count";
    public static final String NULL_COUNT = "null-count";
    public static final String AVG_LENGTH = "avg-length";
    public static final String MAX_LENGTH = "max-length";
    public static final String MAX_VALUE = "max-value";
    public static final String MIN_VALUE = "min-value";

    @Override
    public void validate(DescriptorProperties properties) {
        properties.validateInt(STATISTICS_PROPERTY_VERSION, true, 0, Integer.MAX_VALUE);
        properties.validateLong(STATISTICS_ROW_COUNT, true, 0L);
        StatisticsValidator.validateColumnStats(properties, STATISTICS_COLUMNS);
    }

    public static Map<String, String> normalizeColumnStats(ColumnStats columnStats) {
        HashMap<String, String> stats = new HashMap<String, String>();
        if (columnStats.getNdv() != null) {
            stats.put(DISTINCT_COUNT, String.valueOf(columnStats.getNdv()));
        }
        if (columnStats.getNullCount() != null) {
            stats.put(NULL_COUNT, String.valueOf(columnStats.getNullCount()));
        }
        if (columnStats.getAvgLen() != null) {
            stats.put(AVG_LENGTH, String.valueOf(columnStats.getAvgLen()));
        }
        if (columnStats.getMaxLen() != null) {
            stats.put(MAX_LENGTH, String.valueOf(columnStats.getMaxLen()));
        }
        if (columnStats.getMaxValue() != null) {
            stats.put(MAX_VALUE, String.valueOf(columnStats.getMaxValue()));
        }
        if (columnStats.getMinValue() != null) {
            stats.put(MIN_VALUE, String.valueOf(columnStats.getMinValue()));
        }
        return stats;
    }

    public static void validateColumnStats(DescriptorProperties properties, String key) {
        int columnCount = properties.getIndexedProperty(key, NAME).size();
        for (int i = 0; i < columnCount; ++i) {
            String keyPrefix = key + "." + i + ".";
            properties.validateString(keyPrefix + NAME, false, 1);
            properties.validateLong(keyPrefix + DISTINCT_COUNT, true, 0L);
            properties.validateLong(keyPrefix + NULL_COUNT, true, 0L);
            properties.validateDouble(keyPrefix + AVG_LENGTH, true, 0.0);
            properties.validateInt(keyPrefix + MAX_LENGTH, true, 0);
            properties.validateDouble(keyPrefix + MIN_VALUE, true);
            Optional<Double> min = properties.getOptionalDouble(keyPrefix + MIN_VALUE);
            if (min.isPresent()) {
                properties.validateDouble(keyPrefix + MAX_VALUE, true, min.get());
                continue;
            }
            properties.validateDouble(keyPrefix + MAX_VALUE, true);
        }
    }

    public static Map<String, ColumnStats> readColumnStats(DescriptorProperties properties, String key) {
        int columnCount = properties.getIndexedProperty(key, NAME).size();
        HashMap<String, ColumnStats> stats = new HashMap<String, ColumnStats>();
        for (int i = 0; i < columnCount; ++i) {
            String keyPrefix = key + "." + i + ".";
            String propertyKey = keyPrefix + NAME;
            String name = properties.getString(propertyKey);
            ColumnStats columnStats = new ColumnStats(properties.getOptionalLong(keyPrefix + DISTINCT_COUNT).orElse(null), properties.getOptionalLong(keyPrefix + NULL_COUNT).orElse(null), properties.getOptionalDouble(keyPrefix + AVG_LENGTH).orElse(null), properties.getOptionalInt(keyPrefix + MAX_LENGTH).orElse(null), properties.getOptionalDouble(keyPrefix + MAX_VALUE).orElse(null), properties.getOptionalDouble(keyPrefix + MIN_VALUE).orElse(null));
            stats.put(name, columnStats);
        }
        return stats;
    }
}

