/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.Rowtime;
import org.apache.flink.table.utils.TypeStringUtils;

@PublicEvolving
public class Schema
implements Descriptor {
    public static final String SCHEMA = "schema";
    public static final String SCHEMA_NAME = "name";
    public static final String SCHEMA_TYPE = "type";
    public static final String SCHEMA_PROCTIME = "proctime";
    public static final String SCHEMA_FROM = "from";
    private final Map<String, LinkedHashMap<String, String>> tableSchema = new LinkedHashMap<String, LinkedHashMap<String, String>>();
    private String lastField;

    public Schema schema(TableSchema schema) {
        this.tableSchema.clear();
        this.lastField = null;
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            this.field(schema.getFieldName(i).get(), schema.getFieldType(i).get());
        }
        return this;
    }

    public Schema field(String fieldName, TypeInformation<?> fieldType) {
        this.field(fieldName, TypeStringUtils.writeTypeInfo(fieldType));
        return this;
    }

    public Schema field(String fieldName, String fieldType) {
        if (this.tableSchema.containsKey(fieldName)) {
            throw new ValidationException("Duplicate field name $fieldName.");
        }
        LinkedHashMap<String, String> fieldProperties = new LinkedHashMap<String, String>();
        fieldProperties.put(SCHEMA_TYPE, fieldType);
        this.tableSchema.put(fieldName, fieldProperties);
        this.lastField = fieldName;
        return this;
    }

    public Schema from(String originFieldName) {
        if (this.lastField == null) {
            throw new ValidationException("No field previously defined. Use field() before.");
        }
        this.tableSchema.get(this.lastField).put(SCHEMA_FROM, originFieldName);
        this.lastField = null;
        return this;
    }

    public Schema proctime() {
        if (this.lastField == null) {
            throw new ValidationException("No field defined previously. Use field() before.");
        }
        this.tableSchema.get(this.lastField).put(SCHEMA_PROCTIME, "true");
        this.lastField = null;
        return this;
    }

    public Schema rowtime(Rowtime rowtime) {
        if (this.lastField == null) {
            throw new ValidationException("No field defined previously. Use field() before.");
        }
        this.tableSchema.get(this.lastField).putAll(rowtime.toProperties());
        this.lastField = null;
        return this;
    }

    @Override
    public Map<String, String> toProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        ArrayList<Map<String, String>> subKeyValues = new ArrayList<Map<String, String>>();
        for (Map.Entry<String, LinkedHashMap<String, String>> entry : this.tableSchema.entrySet()) {
            String name = entry.getKey();
            LinkedHashMap<String, String> props = entry.getValue();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(SCHEMA_NAME, name);
            map.putAll(props);
            subKeyValues.add(map);
        }
        properties.putIndexedVariableProperties(SCHEMA, subKeyValues);
        return properties.asMap();
    }
}

