/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

public final class ObjectIdentifier
implements Serializable {
    private final String catalogName;
    private final String databaseName;
    private final String objectName;

    public static ObjectIdentifier of(String catalogName, String databaseName, String objectName) {
        return new ObjectIdentifier(catalogName, databaseName, objectName);
    }

    private ObjectIdentifier(String catalogName, String databaseName, String objectName) {
        this.catalogName = (String)Preconditions.checkNotNull((Object)catalogName, (String)"Catalog name must not be null.");
        this.databaseName = (String)Preconditions.checkNotNull((Object)databaseName, (String)"Database name must not be null.");
        this.objectName = (String)Preconditions.checkNotNull((Object)objectName, (String)"Object name must not be null.");
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String asSerializableString() {
        return String.format("%s.%s.%s", EncodingUtils.escapeIdentifier(this.catalogName), EncodingUtils.escapeIdentifier(this.databaseName), EncodingUtils.escapeIdentifier(this.objectName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectIdentifier that = (ObjectIdentifier)o;
        return this.catalogName.equals(that.catalogName) && this.databaseName.equals(that.databaseName) && this.objectName.equals(that.objectName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.databaseName, this.objectName);
    }

    public String toString() {
        return this.asSerializableString();
    }
}

