/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.TableFactory;

public class NoMatchingTableFactoryException
extends RuntimeException {
    private final String message;
    private final Class<?> factoryClass;
    private final List<TableFactory> factories;
    private final Map<String, String> properties;

    public NoMatchingTableFactoryException(String message, Class<?> factoryClass, List<TableFactory> factories, Map<String, String> properties, Throwable cause) {
        super(cause);
        this.message = message;
        this.factoryClass = factoryClass;
        this.factories = factories;
        this.properties = properties;
    }

    public NoMatchingTableFactoryException(String message, Class<?> factoryClass, List<TableFactory> factories, Map<String, String> properties) {
        this(message, factoryClass, factories, properties, null);
    }

    @Override
    public String getMessage() {
        return String.format("Could not find a suitable table factory for '%s' in\nthe classpath.\n\nReason: %s\n\nThe following properties are requested:\n%s\n\nThe following factories have been considered:\n%s", this.factoryClass.getName(), this.message, DescriptorProperties.toString(this.properties), String.join((CharSequence)"\n", this.factories.stream().map(p -> p.getClass().getName()).collect(Collectors.toList())));
    }
}

