/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical.utils;

import org.apache.flink.table.test.TableAssertions;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.junit.jupiter.api.Test;

class LogicalTypeMergingTest {
    LogicalTypeMergingTest() {
    }

    @Test
    void testFindDivisionDecimalType() {
        TableAssertions.assertThat((LogicalType)LogicalTypeMerging.findDivisionDecimalType((int)32, (int)8, (int)38, (int)8)).hasPrecisionAndScale(38, 6);
        TableAssertions.assertThat((LogicalType)LogicalTypeMerging.findDivisionDecimalType((int)30, (int)20, (int)30, (int)20)).hasPrecisionAndScale(38, 8);
    }

    @Test
    void testFindMultiplicationDecimalType() {
        TableAssertions.assertThat((LogicalType)LogicalTypeMerging.findMultiplicationDecimalType((int)30, (int)10, (int)30, (int)10)).hasPrecisionAndScale(38, 6);
        TableAssertions.assertThat((LogicalType)LogicalTypeMerging.findMultiplicationDecimalType((int)30, (int)20, (int)30, (int)20)).hasPrecisionAndScale(38, 17);
        TableAssertions.assertThat((LogicalType)LogicalTypeMerging.findMultiplicationDecimalType((int)38, (int)2, (int)38, (int)3)).hasPrecisionAndScale(38, 5);
    }

    @Test
    void testFindModuloDecimalType() {
        TableAssertions.assertThat((LogicalType)LogicalTypeMerging.findModuloDecimalType((int)30, (int)10, (int)30, (int)10)).hasPrecisionAndScale(30, 10);
        TableAssertions.assertThat((LogicalType)LogicalTypeMerging.findModuloDecimalType((int)30, (int)20, (int)25, (int)20)).hasPrecisionAndScale(25, 20);
        TableAssertions.assertThat((LogicalType)LogicalTypeMerging.findModuloDecimalType((int)10, (int)10, (int)10, (int)10)).hasPrecisionAndScale(10, 10);
    }

    @Test
    void testFindAdditionDecimalType() {
        TableAssertions.assertThat((LogicalType)LogicalTypeMerging.findAdditionDecimalType((int)38, (int)8, (int)32, (int)8)).hasPrecisionAndScale(38, 7);
        TableAssertions.assertThat((LogicalType)LogicalTypeMerging.findAdditionDecimalType((int)32, (int)8, (int)38, (int)8)).hasPrecisionAndScale(38, 7);
        TableAssertions.assertThat((LogicalType)LogicalTypeMerging.findAdditionDecimalType((int)30, (int)20, (int)28, (int)20)).hasPrecisionAndScale(31, 20);
        TableAssertions.assertThat((LogicalType)LogicalTypeMerging.findAdditionDecimalType((int)10, (int)10, (int)10, (int)10)).hasPrecisionAndScale(11, 10);
        TableAssertions.assertThat((LogicalType)LogicalTypeMerging.findAdditionDecimalType((int)38, (int)5, (int)38, (int)4)).hasPrecisionAndScale(38, 5);
    }

    @Test
    void testFindRoundingDecimalType() {
        TableAssertions.assertThat((LogicalType)LogicalTypeMerging.findRoundDecimalType((int)32, (int)8, (int)5)).hasPrecisionAndScale(30, 5);
        TableAssertions.assertThat((LogicalType)LogicalTypeMerging.findRoundDecimalType((int)32, (int)8, (int)10)).hasPrecisionAndScale(32, 8);
        TableAssertions.assertThat((LogicalType)LogicalTypeMerging.findRoundDecimalType((int)30, (int)20, (int)18)).hasPrecisionAndScale(29, 18);
        TableAssertions.assertThat((LogicalType)LogicalTypeMerging.findRoundDecimalType((int)10, (int)10, (int)2)).hasPrecisionAndScale(3, 2);
    }

    @Test
    void testFindAvgAggType() {
        TableAssertions.assertThat(LogicalTypeMerging.findAvgAggType((LogicalType)LogicalTypeMergingTest.decimal(38, 20))).isDecimalType().hasPrecisionAndScale(38, 20);
        TableAssertions.assertThat(LogicalTypeMerging.findAvgAggType((LogicalType)LogicalTypeMergingTest.decimal(38, 2))).isDecimalType().hasPrecisionAndScale(38, 6);
        TableAssertions.assertThat(LogicalTypeMerging.findAvgAggType((LogicalType)LogicalTypeMergingTest.decimal(38, 8))).isDecimalType().hasPrecisionAndScale(38, 8);
        TableAssertions.assertThat(LogicalTypeMerging.findAvgAggType((LogicalType)LogicalTypeMergingTest.decimal(30, 20))).isDecimalType().hasPrecisionAndScale(38, 20);
        TableAssertions.assertThat(LogicalTypeMerging.findAvgAggType((LogicalType)LogicalTypeMergingTest.decimal(10, 10))).isDecimalType().hasPrecisionAndScale(38, 10);
    }

    private static final DecimalType decimal(int precision, int scale) {
        return new DecimalType(false, precision, scale);
    }
}

