/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.types.LogicalTypesTest;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.CONCURRENT)
class LogicalTypeCastsTest {
    LogicalTypeCastsTest() {
    }

    private static Stream<Arguments> testData() {
        return Stream.of(Arguments.of((Object[])new Object[]{new SmallIntType(), new BigIntType(), true, true}), Arguments.of((Object[])new Object[]{new SmallIntType(false), new SmallIntType(), true, true}), Arguments.of((Object[])new Object[]{new SmallIntType(), new SmallIntType(false), false, true}), Arguments.of((Object[])new Object[]{new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR), new SmallIntType(), true, true}), Arguments.of((Object[])new Object[]{new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH), new SmallIntType(), false, false}), Arguments.of((Object[])new Object[]{new IntType(), new DecimalType(5, 5), true, true}), Arguments.of((Object[])new Object[]{new FloatType(), new IntType(), false, true}), Arguments.of((Object[])new Object[]{new VarCharType(Integer.MAX_VALUE), new FloatType(), false, true}), Arguments.of((Object[])new Object[]{new FloatType(), new VarCharType(Integer.MAX_VALUE), false, true}), Arguments.of((Object[])new Object[]{new DecimalType(3, 2), new VarCharType(Integer.MAX_VALUE), false, true}), Arguments.of((Object[])new Object[]{new TypeInformationRawType(Types.GENERIC(LogicalTypesTest.class)), new TypeInformationRawType(Types.GENERIC(LogicalTypesTest.class)), true, true}), Arguments.of((Object[])new Object[]{new TypeInformationRawType(Types.GENERIC(LogicalTypesTest.class)), new TypeInformationRawType(Types.GENERIC(Object.class)), false, false}), Arguments.of((Object[])new Object[]{new NullType(), new IntType(), true, true}), Arguments.of((Object[])new Object[]{new NullType(), new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType()))), true, true}), Arguments.of((Object[])new Object[]{new ArrayType((LogicalType)new IntType()), new ArrayType((LogicalType)new BigIntType()), true, true}), Arguments.of((Object[])new Object[]{new ArrayType((LogicalType)new IntType()), new ArrayType((LogicalType)new VarCharType(Integer.MAX_VALUE)), false, true}), Arguments.of((Object[])new Object[]{new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType()))), new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new BigIntType()))), true, true}), Arguments.of((Object[])new Object[]{new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType(), "description"), new RowType.RowField("f2", (LogicalType)new IntType()))), new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new BigIntType()))), true, true}), Arguments.of((Object[])new Object[]{new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType()))), new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new BooleanType()))), false, true}), Arguments.of((Object[])new Object[]{new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType()))), new VarCharType(Integer.MAX_VALUE), false, true}), Arguments.of((Object[])new Object[]{new TimestampType(9), new TimestampType(9), true, true}), Arguments.of((Object[])new Object[]{new LocalZonedTimestampType(9), new LocalZonedTimestampType(9), true, true}), Arguments.of((Object[])new Object[]{new TimestampType(3), new LocalZonedTimestampType(3), true, true}), Arguments.of((Object[])new Object[]{new LocalZonedTimestampType(3), new TimestampType(3), true, true}), Arguments.of((Object[])new Object[]{new TimestampType(3), new LocalZonedTimestampType(6), true, true}), Arguments.of((Object[])new Object[]{new LocalZonedTimestampType(3), new TimestampType(6), true, true}), Arguments.of((Object[])new Object[]{new TimestampType(false, 3), new LocalZonedTimestampType(6), true, true}), Arguments.of((Object[])new Object[]{new LocalZonedTimestampType(false, 3), new TimestampType(6), true, true}), Arguments.of((Object[])new Object[]{new TimestampType(6), new LocalZonedTimestampType(3), true, true}), Arguments.of((Object[])new Object[]{new LocalZonedTimestampType(6), new TimestampType(3), true, true}), Arguments.of((Object[])new Object[]{new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new TimestampType()), new RowType.RowField("f2", (LogicalType)new IntType()))), StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"User")).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f1", (LogicalType)new TimestampType()), new StructuredType.StructuredAttribute("f2", (LogicalType)new IntType()))).build(), true, true}), Arguments.of((Object[])new Object[]{new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new TimestampType()), new RowType.RowField("f2", (LogicalType)new IntType()))), StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"User")).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f1", (LogicalType)new TimestampType()), new StructuredType.StructuredAttribute("diff", (LogicalType)new IntType()))).build(), true, true}), Arguments.of((Object[])new Object[]{new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new TimestampType()), new RowType.RowField("f2", (LogicalType)new IntType()))), StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"User")).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f1", (LogicalType)new TimestampType()), new StructuredType.StructuredAttribute("diff", (LogicalType)new TinyIntType()))).build(), false, true}), Arguments.of((Object[])new Object[]{StructuredType.newBuilder(Void.class).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f1", (LogicalType)new TimestampType()), new StructuredType.StructuredAttribute("diff", (LogicalType)new TinyIntType(false)))).build(), StructuredType.newBuilder(Void.class).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f1", (LogicalType)new TimestampType()), new StructuredType.StructuredAttribute("diff", (LogicalType)new TinyIntType(true)))).build(), true, true}), Arguments.of((Object[])new Object[]{StructuredType.newBuilder(Void.class).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f1", (LogicalType)new TimestampType()), new StructuredType.StructuredAttribute("diff", (LogicalType)new IntType()))).build(), StructuredType.newBuilder(Void.class).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f1", (LogicalType)new TimestampType()), new StructuredType.StructuredAttribute("diff", (LogicalType)new TinyIntType()))).build(), false, true}), Arguments.of((Object[])new Object[]{new RawType(Integer.class, (TypeSerializer)IntSerializer.INSTANCE), new BinaryType(), false, true}), Arguments.of((Object[])new Object[]{new RawType(Integer.class, (TypeSerializer)IntSerializer.INSTANCE), VarCharType.STRING_TYPE, false, true}));
    }

    @ParameterizedTest(name="{index}: [From: {0}, To: {1}, Implicit: {2}, Explicit: {3}]")
    @MethodSource(value={"testData"})
    void test(LogicalType sourceType, LogicalType targetType, boolean supportsImplicit, boolean supportsExplicit) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)LogicalTypeCasts.supportsImplicitCast((LogicalType)sourceType, (LogicalType)targetType)).as("Supports implicit casting", new Object[0])).isEqualTo(supportsImplicit);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)LogicalTypeCasts.supportsExplicitCast((LogicalType)sourceType, (LogicalType)targetType)).as("Supports explicit casting", new Object[0])).isEqualTo(supportsExplicit);
    }
}

