/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.connector.sink.TestManagedCommittable;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.util.CollectionUtil;

public class TestManagedSinkCommittableSerializer
implements SimpleVersionedSerializer<TestManagedCommittable> {
    private static final int VERSION = 1;

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(TestManagedCommittable committable) throws IOException {
        DataOutputSerializer out = new DataOutputSerializer(64);
        out.writeInt(committable.getToAdd().size());
        for (Map.Entry<CatalogPartitionSpec, List<RowData>> entry : committable.getToAdd().entrySet()) {
            this.serializePartitionSpec(out, entry.getKey());
            this.serializeRowDataElements(out, entry.getValue());
        }
        out.writeInt(committable.getToDelete().size());
        for (Map.Entry<CatalogPartitionSpec, Collection<Object>> entry : committable.getToDelete().entrySet()) {
            this.serializePartitionSpec(out, entry.getKey());
            this.serializePaths(out, (Set)entry.getValue());
        }
        byte[] result = out.getCopyOfBuffer();
        out.clear();
        return result;
    }

    public TestManagedCommittable deserialize(int version, byte[] serialized) throws IOException {
        if (version == 1) {
            DataInputDeserializer in = new DataInputDeserializer(serialized);
            int newFileSize = in.readInt();
            HashMap<CatalogPartitionSpec, List<RowData>> toCommit = new HashMap<CatalogPartitionSpec, List<RowData>>(newFileSize);
            for (int i = 0; i < newFileSize; ++i) {
                CatalogPartitionSpec partitionSpec = this.deserializePartitionSpec(in);
                List<RowData> elements = this.deserializeRowDataElements(in);
                toCommit.put(partitionSpec, elements);
            }
            int cleanupFileSize = in.readInt();
            HashMap<CatalogPartitionSpec, Set<Path>> toCleanup = new HashMap<CatalogPartitionSpec, Set<Path>>(cleanupFileSize);
            for (int i = 0; i < cleanupFileSize; ++i) {
                CatalogPartitionSpec partitionSpec = this.deserializePartitionSpec(in);
                Set<Path> paths = this.deserializePaths(in);
                toCleanup.put(partitionSpec, paths);
            }
            return new TestManagedCommittable(toCommit, toCleanup);
        }
        throw new IOException(String.format("Unknown version %d", version));
    }

    private void serializePartitionSpec(DataOutputSerializer out, CatalogPartitionSpec partitionSpec) throws IOException {
        Map partitionKVs = partitionSpec.getPartitionSpec();
        out.writeInt(partitionKVs.size());
        for (Map.Entry partitionKV : partitionKVs.entrySet()) {
            out.writeUTF((String)partitionKV.getKey());
            out.writeUTF((String)partitionKV.getValue());
        }
    }

    private void serializeRowDataElements(DataOutputSerializer out, List<RowData> elements) throws IOException {
        out.writeInt(elements.size());
        for (RowData element : elements) {
            out.writeUTF(element.getString(0).toString());
        }
    }

    private void serializePaths(DataOutputSerializer out, Set<Path> paths) throws IOException {
        out.writeInt(paths.size());
        for (Path path : paths) {
            path.write((DataOutputView)out);
        }
    }

    private CatalogPartitionSpec deserializePartitionSpec(DataInputDeserializer in) throws IOException {
        int size = in.readInt();
        LinkedHashMap partitionKVs = CollectionUtil.newLinkedHashMapWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            String partitionKey = in.readUTF();
            String partitionValue = in.readUTF();
            partitionKVs.put(partitionKey, partitionValue);
        }
        return new CatalogPartitionSpec((Map)partitionKVs);
    }

    private List<RowData> deserializeRowDataElements(DataInputDeserializer in) throws IOException {
        int size = in.readInt();
        ArrayList<RowData> elements = new ArrayList<RowData>(size);
        for (int i = 0; i < size; ++i) {
            elements.add((RowData)GenericRowData.of((Object[])new Object[]{StringData.fromString((String)in.readUTF())}));
        }
        return elements;
    }

    private Set<Path> deserializePaths(DataInputDeserializer in) throws IOException {
        int size = in.readInt();
        HashSet<Path> paths = new HashSet<Path>(size);
        for (int i = 0; i < size; ++i) {
            Path path = new Path();
            path.read((DataInputView)in);
            paths.add(path);
        }
        return paths;
    }
}

