/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.DefinedProctimeAttribute;
import org.apache.flink.table.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.utils.TypeMappingUtils;
import org.apache.flink.types.Row;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TypeMappingUtilsTest {
    TypeMappingUtilsTest() {
    }

    @Test
    void testFieldMappingReordered() {
        int[] indices = TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f1", DataTypes.BIGINT()).field("f0", DataTypes.STRING()).build().getTableColumns(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BIGINT())}), Function.identity());
        Assertions.assertThat((int[])indices).isEqualTo((Object)new int[]{1, 0});
    }

    @Test
    void testFieldMappingNonMatchingTypes() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f1", DataTypes.BIGINT()).field("f0", DataTypes.TIMESTAMP((int)3)).build().getTableColumns(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BIGINT())}), Function.identity())).isInstanceOf(ValidationException.class)).hasMessage("Type TIMESTAMP(3) of table field 'f0' does not match with the physical type STRING of the 'f0' field of the TableSource return type.");
    }

    @Test
    void testFieldMappingNonMatchingPrecision() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f0", DataTypes.TIMESTAMP((int)9)).build().getTableColumns(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.TIMESTAMP((int)3))}), Function.identity())).isInstanceOf(ValidationException.class)).hasMessage("Type TIMESTAMP(9) of table field 'f0' does not match with the physical type TIMESTAMP(3) of the 'f0' field of the TableSource return type.");
    }

    @Test
    void testNameMappingDoesNotExist() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f0", DataTypes.BIGINT()).build().getTableColumns(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.BIGINT())}), str -> null)).isInstanceOf(ValidationException.class)).hasMessage("Field 'f0' could not be resolved by the field mapping.");
    }

    @Test
    void testFieldMappingLegacyDecimalType() {
        int[] indices = TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f0", DataTypes.DECIMAL((int)38, (int)18)).build().getTableColumns(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)TypeConversions.fromLegacyInfoToDataType((TypeInformation)Types.BIG_DEC))}), Function.identity());
        Assertions.assertThat((int[])indices).isEqualTo((Object)new int[]{0});
    }

    @Test
    void testFieldMappingLegacyDecimalTypeNotMatchingPrecision() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f0", DataTypes.DECIMAL((int)38, (int)10)).build().getTableColumns(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)TypeConversions.fromLegacyInfoToDataType((TypeInformation)Types.BIG_DEC))}), Function.identity())).isInstanceOf(ValidationException.class)).hasMessage("Type DECIMAL(38, 10) of table field 'f0' does not match with the physical type LEGACY('DECIMAL', 'DECIMAL') of the 'f0' field of the TableSource return type.").cause().isInstanceOf(ValidationException.class)).hasMessage("Legacy decimal type can only be mapped to DECIMAL(38, 18).");
    }

    @Test
    void testFieldMappingRowTypeNotMatchingNamesInNestedType() {
        int[] indices = TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f0", DataTypes.DECIMAL((int)38, (int)18)).field("f1", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"logical_f1_0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"logical_f1_1", (DataType)DataTypes.STRING())})).build().getTableColumns(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.DECIMAL((int)38, (int)18)), DataTypes.FIELD((String)"f1", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"physical_f1_0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"physical_f1_1", (DataType)DataTypes.STRING())}))}), Function.identity());
        Assertions.assertThat((int[])indices).isEqualTo((Object)new int[]{0, 1});
    }

    @Test
    void testFieldMappingRowTypeNotMatchingTypesInNestedType() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f0", DataTypes.DECIMAL((int)38, (int)18)).field("f1", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f1_0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f1_1", (DataType)DataTypes.STRING())})).build().getTableColumns(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.DECIMAL((int)38, (int)18)), DataTypes.FIELD((String)"f1", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f1_0", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f1_1", (DataType)DataTypes.STRING())}))}), Function.identity())).isInstanceOf(ValidationException.class)).hasMessage("Type ROW<`f1_0` BIGINT, `f1_1` STRING> of table field 'f1' does not match with the physical type ROW<`f1_0` STRING, `f1_1` STRING> of the 'f1' field of the TableSource return type.");
    }

    @Test
    void testFieldMappingLegacyCompositeType() {
        int[] indices = TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f1", DataTypes.BIGINT()).field("f0", DataTypes.STRING()).build().getTableColumns(), (DataType)TypeConversions.fromLegacyInfoToDataType((TypeInformation)Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.STRING, Types.LONG})), Function.identity());
        Assertions.assertThat((int[])indices).isEqualTo((Object)new int[]{1, 0});
    }

    @Test
    void testFieldMappingLegacyCompositeTypeWithRenaming() {
        int[] indices = TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("a", DataTypes.BIGINT()).field("b", DataTypes.STRING()).build().getTableColumns(), (DataType)TypeConversions.fromLegacyInfoToDataType((TypeInformation)Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.STRING, Types.LONG})), str -> {
            switch (str) {
                case "a": {
                    return "f1";
                }
                case "b": {
                    return "f0";
                }
            }
            throw new AssertionError();
        });
        Assertions.assertThat((int[])indices).isEqualTo((Object)new int[]{1, 0});
    }

    @Test
    void testMappingWithBatchTimeAttributes() {
        TestTableSource tableSource = new TestTableSource(DataTypes.BIGINT(), Collections.singletonList("rowtime"), "proctime");
        int[] indices = TypeMappingUtils.computePhysicalIndicesOrTimeAttributeMarkers((TableSource)tableSource, (List)TableSchema.builder().field("a", Types.LONG).field("rowtime", Types.SQL_TIMESTAMP).field("proctime", Types.SQL_TIMESTAMP).build().getTableColumns(), (boolean)false, Function.identity());
        Assertions.assertThat((int[])indices).isEqualTo((Object)new int[]{0, -3, -4});
    }

    @Test
    void testMappingWithStreamTimeAttributes() {
        TestTableSource tableSource = new TestTableSource(DataTypes.BIGINT(), Collections.singletonList("rowtime"), "proctime");
        int[] indices = TypeMappingUtils.computePhysicalIndicesOrTimeAttributeMarkers((TableSource)tableSource, (List)TableSchema.builder().field("a", Types.LONG).field("rowtime", Types.SQL_TIMESTAMP).field("proctime", Types.SQL_TIMESTAMP).build().getTableColumns(), (boolean)true, Function.identity());
        Assertions.assertThat((int[])indices).isEqualTo((Object)new int[]{0, -1, -2});
    }

    @Test
    void testMappingWithStreamTimeAttributesFromCompositeType() {
        TestTableSource tableSource = new TestTableSource(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"b", (DataType)DataTypes.TIME()), DataTypes.FIELD((String)"a", (DataType)DataTypes.BIGINT())}), Collections.singletonList("rowtime"), "proctime");
        int[] indices = TypeMappingUtils.computePhysicalIndicesOrTimeAttributeMarkers((TableSource)tableSource, (List)TableSchema.builder().field("a", Types.LONG).field("rowtime", Types.SQL_TIMESTAMP).field("proctime", Types.SQL_TIMESTAMP).build().getTableColumns(), (boolean)true, Function.identity());
        Assertions.assertThat((int[])indices).isEqualTo((Object)new int[]{1, -1, -2});
    }

    @Test
    void testWrongLogicalTypeForRowtimeAttribute() {
        TestTableSource tableSource = new TestTableSource(DataTypes.BIGINT(), Collections.singletonList("rowtime"), "proctime");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeMappingUtils.computePhysicalIndicesOrTimeAttributeMarkers((TableSource)tableSource, (List)TableSchema.builder().field("a", Types.LONG).field("rowtime", Types.SQL_TIME).field("proctime", Types.SQL_TIMESTAMP).build().getTableColumns(), (boolean)false, Function.identity())).isInstanceOf(ValidationException.class)).hasMessage("Rowtime field 'rowtime' has invalid type TIME(0). Rowtime attributes must be of a Timestamp family.");
    }

    @Test
    void testWrongLogicalTypeForProctimeAttribute() {
        TestTableSource tableSource = new TestTableSource(DataTypes.BIGINT(), Collections.singletonList("rowtime"), "proctime");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeMappingUtils.computePhysicalIndicesOrTimeAttributeMarkers((TableSource)tableSource, (List)TableSchema.builder().field("a", Types.LONG).field("rowtime", Types.SQL_TIMESTAMP).field("proctime", Types.SQL_TIME).build().getTableColumns(), (boolean)false, Function.identity())).isInstanceOf(ValidationException.class)).hasMessage("Proctime field 'proctime' has invalid type TIME(0). Proctime attributes must be of a Timestamp family.");
    }

    @Test
    void testCheckPhysicalLogicalTypeCompatible() {
        TableSchema tableSchema = TableSchema.builder().field("a", DataTypes.VARCHAR((int)2)).field("b", DataTypes.DECIMAL((int)20, (int)2)).build();
        TestTableSink tableSink = new TestTableSink(tableSchema);
        LegacyTypeInformationType legacyDataType = (LegacyTypeInformationType)tableSink.getConsumedDataType().getLogicalType();
        TypeInformation legacyTypeInfo = ((TupleTypeInfo)legacyDataType.getTypeInformation()).getTypeAt(1);
        DataType physicalType = TypeConversions.fromLegacyInfoToDataType((TypeInformation)legacyTypeInfo);
        ResolvedSchema physicSchema = DataTypeUtils.expandCompositeTypeToSchema((DataType)physicalType);
        DataType[] logicalDataTypes = tableSchema.getFieldDataTypes();
        List physicalDataTypes = physicSchema.getColumnDataTypes();
        for (int i = 0; i < logicalDataTypes.length; ++i) {
            TypeMappingUtils.checkPhysicalLogicalTypeCompatible((LogicalType)((DataType)physicalDataTypes.get(i)).getLogicalType(), (LogicalType)logicalDataTypes[i].getLogicalType(), (String)"physicalField", (String)"logicalField", (boolean)false);
        }
    }

    private static class TestTableSink
    implements TableSink<Tuple2<Boolean, Row>> {
        private final TableSchema tableSchema;

        private TestTableSink(TableSchema tableSchema) {
            this.tableSchema = tableSchema;
        }

        TypeInformation<Row> getRecordType() {
            return this.tableSchema.toRowType();
        }

        public TypeInformation<Tuple2<Boolean, Row>> getOutputType() {
            return new TupleTypeInfo(new TypeInformation[]{Types.BOOLEAN, this.getRecordType()});
        }

        public String[] getFieldNames() {
            return this.tableSchema.getFieldNames();
        }

        public TypeInformation<?>[] getFieldTypes() {
            return this.tableSchema.getFieldTypes();
        }

        public TableSink<Tuple2<Boolean, Row>> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
            return null;
        }
    }

    private static class TestTableSource
    implements TableSource<Object>,
    DefinedProctimeAttribute,
    DefinedRowtimeAttributes {
        private final DataType producedDataType;
        private final List<String> rowtimeAttributes;
        private final String proctimeAttribute;

        private TestTableSource(DataType producedDataType, List<String> rowtimeAttributes, String proctimeAttribute) {
            this.producedDataType = producedDataType;
            this.rowtimeAttributes = rowtimeAttributes;
            this.proctimeAttribute = proctimeAttribute;
        }

        @Nullable
        public String getProctimeAttribute() {
            return this.proctimeAttribute;
        }

        public List<RowtimeAttributeDescriptor> getRowtimeAttributeDescriptors() {
            return this.rowtimeAttributes.stream().map(attr -> new RowtimeAttributeDescriptor(attr, null, null)).collect(Collectors.toList());
        }

        public DataType getProducedDataType() {
            return this.producedDataType;
        }

        public TableSchema getTableSchema() {
            throw new UnsupportedOperationException("Should not be called");
        }
    }
}

