/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class LogicalCommonTypeTest {
    LogicalCommonTypeTest() {
    }

    private static Stream<Arguments> testData() {
        return Stream.of(Arguments.of((Object[])new Object[]{Arrays.asList(new IntType(), new IntType()), new IntType()}), Arguments.of((Object[])new Object[]{Arrays.asList(new IntType(), new ArrayType((LogicalType)new IntType())), null}), Arguments.of((Object[])new Object[]{Arrays.asList(new IntType(), new VarCharType(23)), null}), Arguments.of((Object[])new Object[]{Arrays.asList(new BinaryType(), new VarCharType(23)), null}), Arguments.of((Object[])new Object[]{Arrays.asList(new IntType(false), new IntType(false)), new IntType(false)}), Arguments.of((Object[])new Object[]{Arrays.asList(new IntType(true), new BigIntType(false)), new BigIntType()}), Arguments.of((Object[])new Object[]{Arrays.asList(new NullType(), new NullType()), null}), Arguments.of((Object[])new Object[]{Arrays.asList(new NullType(), new IntType(), new IntType()), new IntType()}), Arguments.of((Object[])new Object[]{Arrays.asList(new ArrayType((LogicalType)new IntType()), new ArrayType((LogicalType)new IntType())), new ArrayType((LogicalType)new IntType())}), Arguments.of((Object[])new Object[]{Arrays.asList(new ArrayType((LogicalType)new BigIntType()), new ArrayType((LogicalType)new IntType())), new ArrayType((LogicalType)new BigIntType())}), Arguments.of((Object[])new Object[]{Arrays.asList(new MultisetType((LogicalType)new BigIntType()), new MultisetType((LogicalType)new IntType())), new MultisetType((LogicalType)new BigIntType())}), Arguments.of((Object[])new Object[]{Arrays.asList(new MapType((LogicalType)new BigIntType(), (LogicalType)new DoubleType()), new MapType((LogicalType)new IntType(), (LogicalType)new DoubleType())), new MapType((LogicalType)new BigIntType(), (LogicalType)new DoubleType())}), Arguments.of((Object[])new Object[]{Arrays.asList(RowType.of((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new BigIntType()}), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(), new IntType()})), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(), new BigIntType()})}), Arguments.of((Object[])new Object[]{Arrays.asList(new CharType(2), new CharType(2)), new CharType(2)}), Arguments.of((Object[])new Object[]{Arrays.asList(CharType.ofEmptyLiteral(), CharType.ofEmptyLiteral()), CharType.ofEmptyLiteral()}), Arguments.of((Object[])new Object[]{Arrays.asList(new CharType(2), new CharType(4)), new VarCharType(4)}), Arguments.of((Object[])new Object[]{Arrays.asList(new VarCharType(2), VarCharType.STRING_TYPE), VarCharType.STRING_TYPE}), Arguments.of((Object[])new Object[]{Arrays.asList(new VarCharType(2), new CharType(5)), new VarCharType(5)}), Arguments.of((Object[])new Object[]{Arrays.asList(new CharType(5), new VarCharType(2), new VarCharType(7)), new VarCharType(7)}), Arguments.of((Object[])new Object[]{Arrays.asList(new BinaryType(2), new BinaryType(4)), new VarBinaryType(4)}), Arguments.of((Object[])new Object[]{Arrays.asList(new BinaryType(5), new VarBinaryType(2), new VarBinaryType(7)), new VarBinaryType(7)}), Arguments.of((Object[])new Object[]{Arrays.asList(new DoubleType(), new FloatType()), new DoubleType()}), Arguments.of((Object[])new Object[]{Arrays.asList(new DoubleType(), new DecimalType(2, 2)), new DoubleType()}), Arguments.of((Object[])new Object[]{Arrays.asList(new IntType(), new FloatType()), new FloatType()}), Arguments.of((Object[])new Object[]{Arrays.asList(new DecimalType(2, 2), new DoubleType(), new FloatType()), new DoubleType()}), Arguments.of((Object[])new Object[]{Arrays.asList(new DecimalType(2, 2), new DecimalType(5, 2), new DecimalType(7, 5)), new DecimalType(8, 5)}), Arguments.of((Object[])new Object[]{Arrays.asList(new DecimalType(2, 2), new IntType(), new BigIntType()), new DecimalType(21, 2)}), Arguments.of((Object[])new Object[]{Arrays.asList(new DateType(), new DateType(), new TimeType()), null}), Arguments.of((Object[])new Object[]{Arrays.asList(new TimeType(3), new TimeType(5), new TimeType(2)), new TimeType(5)}), Arguments.of((Object[])new Object[]{Arrays.asList(new TimestampType(3), new TimestampType(5), new TimestampType(2)), new TimestampType(5)}), Arguments.of((Object[])new Object[]{Arrays.asList(new TimestampType(3), new ZonedTimestampType(5), new LocalZonedTimestampType(2)), new ZonedTimestampType(5)}), Arguments.of((Object[])new Object[]{Arrays.asList(new TimestampType(3), new LocalZonedTimestampType(2)), new LocalZonedTimestampType(3)}), Arguments.of((Object[])new Object[]{Arrays.asList(new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY), new DateType()), new DateType()}), Arguments.of((Object[])new Object[]{Arrays.asList(new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.MONTH), new DateType()), new DateType()}), Arguments.of((Object[])new Object[]{Arrays.asList(new TimeType(), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.MINUTE)), new TimeType()}), Arguments.of((Object[])new Object[]{Arrays.asList(new DateType(), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY)), new DateType()}), Arguments.of((Object[])new Object[]{Arrays.asList(new IntType(), new DateType()), new DateType()}), Arguments.of((Object[])new Object[]{Arrays.asList(new TimeType(), new DecimalType()), null}), Arguments.of((Object[])new Object[]{Arrays.asList(new TimestampType(), new DecimalType()), new TimestampType()}), Arguments.of((Object[])new Object[]{Arrays.asList(new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_MINUTE), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.SECOND)), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_SECOND)}), Arguments.of((Object[])new Object[]{Arrays.asList(new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.HOUR), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.SECOND, 2, 0)), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.HOUR_TO_SECOND, 2, 6)}), Arguments.of((Object[])new Object[]{Arrays.asList(new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.MONTH), new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR)), new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH)}));
    }

    @ParameterizedTest(name="{index}: [Types: {0}, To: {1}]")
    @MethodSource(value={"testData"})
    void testCommonType(List<LogicalType> types, @Nullable LogicalType commonType) {
        if (commonType == null) {
            Assertions.assertThat((Optional)LogicalTypeMerging.findCommonType(types)).isEmpty();
        } else {
            Assertions.assertThat((Optional)LogicalTypeMerging.findCommonType(types)).contains((Object)commonType);
        }
    }
}

