/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataTypeVisitor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class DataType
implements AbstractDataType<DataType>,
Serializable {
    protected final LogicalType logicalType;
    protected final Class<?> conversionClass;

    DataType(LogicalType logicalType, @Nullable Class<?> conversionClass) {
        this.logicalType = (LogicalType)Preconditions.checkNotNull((Object)logicalType, (String)"Logical type must not be null.");
        this.conversionClass = DataType.performEarlyClassValidation(logicalType, DataType.ensureConversionClass(logicalType, conversionClass));
    }

    public LogicalType getLogicalType() {
        return this.logicalType;
    }

    public Class<?> getConversionClass() {
        return this.conversionClass;
    }

    public abstract List<DataType> getChildren();

    public abstract <R> R accept(DataTypeVisitor<R> var1);

    public DataType toInternal() {
        return DataTypeUtils.toInternalDataType(this);
    }

    public String toString() {
        return this.logicalType.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataType dataType = (DataType)o;
        return this.logicalType.equals(dataType.logicalType) && this.conversionClass.equals(dataType.conversionClass);
    }

    public int hashCode() {
        return Objects.hash(this.logicalType, this.conversionClass);
    }

    public static List<String> getFieldNames(DataType dataType) {
        LogicalType type = dataType.getLogicalType();
        if (type.is(LogicalTypeRoot.DISTINCT_TYPE)) {
            return DataType.getFieldNames(dataType.getChildren().get(0));
        }
        if (LogicalTypeChecks.isCompositeType(type)) {
            return LogicalTypeChecks.getFieldNames(type);
        }
        return Collections.emptyList();
    }

    public static List<DataType> getFieldDataTypes(DataType dataType) {
        LogicalType type = dataType.getLogicalType();
        if (type.is(LogicalTypeRoot.DISTINCT_TYPE)) {
            return DataType.getFieldDataTypes(dataType.getChildren().get(0));
        }
        if (LogicalTypeChecks.isCompositeType(type)) {
            return dataType.getChildren();
        }
        return Collections.emptyList();
    }

    public static int getFieldCount(DataType dataType) {
        return DataType.getFieldDataTypes(dataType).size();
    }

    public static List<DataTypes.Field> getFields(DataType dataType) {
        List<String> names = DataType.getFieldNames(dataType);
        List<DataType> dataTypes = DataType.getFieldDataTypes(dataType);
        return IntStream.range(0, names.size()).mapToObj(i -> DataTypes.FIELD((String)names.get(i), (DataType)dataTypes.get(i))).collect(Collectors.toList());
    }

    private static <C> Class<C> performEarlyClassValidation(LogicalType logicalType, Class<C> candidate) {
        if (candidate != null && !logicalType.supportsInputConversion(candidate) && !logicalType.supportsOutputConversion(candidate)) {
            throw new ValidationException(String.format("Logical type '%s' does not support a conversion from or to class '%s'.", logicalType.asSummaryString(), candidate.getName()));
        }
        return candidate;
    }

    private static Class<?> ensureConversionClass(LogicalType logicalType, @Nullable Class<?> clazz) {
        if (clazz == null) {
            return logicalType.getDefaultConversion();
        }
        return clazz;
    }
}

