/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.utils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.types.DataType;

public class ResolvedExpressionMock
implements ResolvedExpression {
    private final DataType outputDataType;
    private final Supplier<String> stringRepresentation;

    public ResolvedExpressionMock(DataType outputDataType, Supplier<String> stringRepresentation) {
        this.outputDataType = outputDataType;
        this.stringRepresentation = stringRepresentation;
    }

    public static ResolvedExpression of(DataType outputDataType, String stringRepresentation) {
        return new ResolvedExpressionMock(outputDataType, () -> stringRepresentation);
    }

    public String asSummaryString() {
        return this.stringRepresentation.get();
    }

    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    public <R> R accept(ExpressionVisitor<R> visitor) {
        return (R)visitor.visit((Expression)this);
    }

    public String asSerializableString() {
        return this.stringRepresentation.get();
    }

    public DataType getOutputDataType() {
        return this.outputDataType;
    }

    public List<ResolvedExpression> getResolvedChildren() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.asSummaryString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolvedExpression)) {
            return false;
        }
        ResolvedExpression that = (ResolvedExpression)o;
        return Objects.equals(this.outputDataType, that.getOutputDataType()) && Objects.equals(this.stringRepresentation.get(), that.asSerializableString());
    }

    public int hashCode() {
        return Objects.hash(this.outputDataType, this.stringRepresentation);
    }
}

