/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.extraction.FunctionResultTemplate;
import org.apache.flink.table.types.extraction.FunctionSignatureTemplate;
import org.apache.flink.table.types.extraction.FunctionTemplate;

@Internal
final class TemplateUtils {
    static Set<FunctionTemplate> extractGlobalFunctionTemplates(DataTypeFactory typeFactory, Class<? extends UserDefinedFunction> function) {
        return TemplateUtils.asFunctionTemplates(typeFactory, ExtractionUtils.collectAnnotationsOfClass(FunctionHint.class, function));
    }

    static Set<FunctionTemplate> extractLocalFunctionTemplates(DataTypeFactory typeFactory, Method method) {
        return TemplateUtils.asFunctionTemplates(typeFactory, ExtractionUtils.collectAnnotationsOfMethod(FunctionHint.class, method));
    }

    static Set<FunctionTemplate> asFunctionTemplates(DataTypeFactory typeFactory, Set<FunctionHint> hints) {
        return hints.stream().map(hint -> {
            try {
                return FunctionTemplate.fromAnnotation(typeFactory, hint);
            }
            catch (Throwable t) {
                throw ExtractionUtils.extractionError(t, "Error in function hint annotation.", new Object[0]);
            }
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    static Set<FunctionResultTemplate> findResultOnlyTemplates(Set<FunctionTemplate> functionTemplates, Function<FunctionTemplate, FunctionResultTemplate> accessor) {
        return functionTemplates.stream().filter(t -> t.getSignatureTemplate() == null && accessor.apply((FunctionTemplate)t) != null).map(accessor).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Nullable
    static FunctionResultTemplate findResultOnlyTemplate(Set<FunctionResultTemplate> globalResultOnly, Set<FunctionResultTemplate> localResultOnly, Set<FunctionTemplate> explicitMappings, Function<FunctionTemplate, FunctionResultTemplate> accessor) {
        Set resultOnly = Stream.concat(globalResultOnly.stream(), localResultOnly.stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        Set allResults = Stream.concat(resultOnly.stream(), explicitMappings.stream().map(accessor)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (resultOnly.size() == 1 && allResults.size() == 1) {
            return resultOnly.stream().findFirst().orElse(null);
        }
        if (resultOnly.size() > 1 || !resultOnly.isEmpty() && !explicitMappings.isEmpty()) {
            throw ExtractionUtils.extractionError("Function hints that lead to ambiguous results are not allowed.", new Object[0]);
        }
        return null;
    }

    static Set<FunctionTemplate> findResultMappingTemplates(Set<FunctionTemplate> globalTemplates, Set<FunctionTemplate> localTemplates, Function<FunctionTemplate, FunctionResultTemplate> accessor) {
        return Stream.concat(globalTemplates.stream(), localTemplates.stream()).filter(t -> t.getSignatureTemplate() != null && accessor.apply((FunctionTemplate)t) != null).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    static Set<FunctionSignatureTemplate> findInputOnlyTemplates(Set<FunctionTemplate> global, Set<FunctionTemplate> local, Function<FunctionTemplate, FunctionResultTemplate> accessor) {
        return Stream.concat(global.stream(), local.stream()).filter(t -> t.getSignatureTemplate() != null && accessor.apply((FunctionTemplate)t) == null).map(FunctionTemplate::getSignatureTemplate).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private TemplateUtils() {
    }
}

