/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.module;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.module.Module;

public class CoreModule
implements Module {
    public static final CoreModule INSTANCE = new CoreModule();
    private final List<BuiltInFunctionDefinition> functionDefinitions = BuiltInFunctionDefinitions.getDefinitions();
    private Set<String> functionNames = new HashSet<String>();

    private CoreModule() {
    }

    @Override
    public Set<String> listFunctions() {
        if (this.functionNames.isEmpty()) {
            this.functionNames = this.functionDefinitions.stream().map(BuiltInFunctionDefinition::getName).collect(Collectors.toSet());
        }
        return this.functionNames;
    }

    @Override
    public Optional<FunctionDefinition> getFunctionDefinition(String name) {
        return this.functionDefinitions.stream().filter(f -> f.getName().equalsIgnoreCase(name)).findFirst().map(Function.identity());
    }
}

