/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class Column {
    protected final String name;
    protected final DataType dataType;

    private Column(String name, DataType dataType) {
        this.name = name;
        this.dataType = dataType;
    }

    public static PhysicalColumn physical(String name, DataType dataType) {
        Preconditions.checkNotNull((Object)name, (String)"Column name can not be null.");
        Preconditions.checkNotNull((Object)dataType, (String)"Column data type can not be null.");
        return new PhysicalColumn(name, dataType);
    }

    public static ComputedColumn computed(String name, ResolvedExpression expression) {
        Preconditions.checkNotNull((Object)name, (String)"Column name can not be null.");
        Preconditions.checkNotNull((Object)expression, (String)"Column expression can not be null.");
        return new ComputedColumn(name, expression.getOutputDataType(), expression);
    }

    public static MetadataColumn metadata(String name, DataType dataType, @Nullable String metadataKey, boolean isVirtual) {
        Preconditions.checkNotNull((Object)name, (String)"Column name can not be null.");
        Preconditions.checkNotNull((Object)dataType, (String)"Column data type can not be null.");
        return new MetadataColumn(name, dataType, metadataKey, isVirtual);
    }

    public abstract boolean isPhysical();

    public abstract boolean isPersisted();

    public DataType getDataType() {
        return this.dataType;
    }

    public String getName() {
        return this.name;
    }

    public String asSummaryString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EncodingUtils.escapeIdentifier(this.name));
        sb.append(" ");
        sb.append(this.dataType);
        this.explainExtras().ifPresent(e -> {
            sb.append(" ");
            sb.append((String)e);
        });
        return sb.toString();
    }

    public abstract Optional<String> explainExtras();

    public abstract Column copy(DataType var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column that = (Column)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.dataType, that.dataType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataType);
    }

    public String toString() {
        return this.asSummaryString();
    }

    public static final class MetadataColumn
    extends Column {
        @Nullable
        private final String metadataKey;
        private final boolean isVirtual;

        private MetadataColumn(String name, DataType dataType, @Nullable String metadataKey, boolean isVirtual) {
            super(name, dataType);
            this.metadataKey = metadataKey;
            this.isVirtual = isVirtual;
        }

        public boolean isVirtual() {
            return this.isVirtual;
        }

        public Optional<String> getMetadataKey() {
            return Optional.ofNullable(this.metadataKey);
        }

        @Override
        public boolean isPhysical() {
            return false;
        }

        @Override
        public boolean isPersisted() {
            return !this.isVirtual;
        }

        @Override
        public Optional<String> explainExtras() {
            StringBuilder sb = new StringBuilder();
            sb.append("METADATA");
            if (this.metadataKey != null) {
                sb.append(" FROM ");
                sb.append("'");
                sb.append(EncodingUtils.escapeSingleQuotes(this.metadataKey));
                sb.append("'");
            }
            if (this.isVirtual) {
                sb.append(" VIRTUAL");
            }
            return Optional.of(sb.toString());
        }

        @Override
        public Column copy(DataType newDataType) {
            return new MetadataColumn(this.name, newDataType, this.metadataKey, this.isVirtual);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MetadataColumn that = (MetadataColumn)o;
            return this.isVirtual == that.isVirtual && Objects.equals(this.metadataKey, that.metadataKey);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.metadataKey, this.isVirtual);
        }
    }

    public static final class ComputedColumn
    extends Column {
        private final ResolvedExpression expression;

        private ComputedColumn(String name, DataType dataType, ResolvedExpression expression) {
            super(name, dataType);
            this.expression = expression;
        }

        @Override
        public boolean isPhysical() {
            return false;
        }

        @Override
        public boolean isPersisted() {
            return false;
        }

        public ResolvedExpression getExpression() {
            return this.expression;
        }

        @Override
        public Optional<String> explainExtras() {
            return Optional.of("AS " + this.expression.asSummaryString());
        }

        @Override
        public Column copy(DataType newDataType) {
            return new ComputedColumn(this.name, newDataType, this.expression);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ComputedColumn that = (ComputedColumn)o;
            return this.expression.equals(that.expression);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.expression);
        }
    }

    public static final class PhysicalColumn
    extends Column {
        private PhysicalColumn(String name, DataType dataType) {
            super(name, dataType);
        }

        @Override
        public boolean isPhysical() {
            return true;
        }

        @Override
        public boolean isPersisted() {
            return true;
        }

        @Override
        public Optional<String> explainExtras() {
            return Optional.empty();
        }

        @Override
        public Column copy(DataType newDataType) {
            return new PhysicalColumn(this.name, newDataType);
        }
    }
}

