/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.time.Period;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class YearMonthIntervalType
extends LogicalType {
    private static final long serialVersionUID = 1L;
    public static final int MIN_PRECISION = 1;
    public static final int MAX_PRECISION = 4;
    public static final int DEFAULT_PRECISION = 2;
    private static final String YEAR_FORMAT = "INTERVAL YEAR(%d)";
    private static final String YEAR_TO_MONTH_FORMAT = "INTERVAL YEAR(%d) TO MONTH";
    private static final String MONTH_FORMAT = "INTERVAL MONTH";
    private static final Set<String> NULL_OUTPUT_CONVERSION = YearMonthIntervalType.conversionSet(Period.class.getName(), Integer.class.getName());
    private static final Set<String> NOT_NULL_INPUT_OUTPUT_CONVERSION = YearMonthIntervalType.conversionSet(Period.class.getName(), Integer.class.getName(), Integer.TYPE.getName());
    private static final Class<?> DEFAULT_CONVERSION = Period.class;
    private final YearMonthResolution resolution;
    private final int yearPrecision;

    public YearMonthIntervalType(boolean isNullable, YearMonthResolution resolution, int yearPrecision) {
        super(isNullable, LogicalTypeRoot.INTERVAL_YEAR_MONTH);
        Preconditions.checkNotNull((Object)((Object)resolution));
        if (resolution == YearMonthResolution.MONTH && yearPrecision != 2) {
            throw new ValidationException(String.format("Year precision of sub-year intervals must be equal to the default precision %d.", 2));
        }
        if (yearPrecision < 1 || yearPrecision > 4) {
            throw new ValidationException(String.format("Year precision of year-month intervals must be between %d and %d (both inclusive).", 1, 4));
        }
        this.resolution = resolution;
        this.yearPrecision = yearPrecision;
    }

    public YearMonthIntervalType(YearMonthResolution resolution, int yearPrecision) {
        this(true, resolution, yearPrecision);
    }

    public YearMonthIntervalType(YearMonthResolution resolution) {
        this(resolution, 2);
    }

    public YearMonthResolution getResolution() {
        return this.resolution;
    }

    public int getYearPrecision() {
        return this.yearPrecision;
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new YearMonthIntervalType(isNullable, this.resolution, this.yearPrecision);
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(this.getResolutionFormat(), this.yearPrecision);
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return NOT_NULL_INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        if (this.isNullable()) {
            return NULL_OUTPUT_CONVERSION.contains(clazz.getName());
        }
        return NOT_NULL_INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public Class<?> getDefaultConversion() {
        return DEFAULT_CONVERSION;
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        YearMonthIntervalType that = (YearMonthIntervalType)o;
        return this.yearPrecision == that.yearPrecision && this.resolution == that.resolution;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.resolution, this.yearPrecision});
    }

    private String getResolutionFormat() {
        switch (this.resolution) {
            case YEAR: {
                return YEAR_FORMAT;
            }
            case YEAR_TO_MONTH: {
                return YEAR_TO_MONTH_FORMAT;
            }
            case MONTH: {
                return MONTH_FORMAT;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static enum YearMonthResolution {
        YEAR,
        YEAR_TO_MONTH,
        MONTH;

    }
}

