/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@PublicEvolving
public abstract class UserDefinedType
extends LogicalType {
    @Nullable
    private final ObjectIdentifier objectIdentifier;
    private final boolean isFinal;
    @Nullable
    private final String description;

    UserDefinedType(boolean isNullable, LogicalTypeRoot typeRoot, @Nullable ObjectIdentifier objectIdentifier, boolean isFinal, @Nullable String description) {
        super(isNullable, typeRoot);
        this.objectIdentifier = objectIdentifier;
        this.isFinal = isFinal;
        this.description = description;
    }

    public Optional<ObjectIdentifier> getObjectIdentifier() {
        return Optional.ofNullable(this.objectIdentifier);
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    public String asSerializableString() {
        if (this.objectIdentifier == null) {
            throw new TableException("An unregistered user-defined type has no serializable string representation.");
        }
        return this.withNullability(this.objectIdentifier.asSerializableString(), new Object[0]);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserDefinedType that = (UserDefinedType)o;
        return this.isFinal == that.isFinal && Objects.equals(this.objectIdentifier, that.objectIdentifier) && Objects.equals(this.description, that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.objectIdentifier, this.isFinal, this.description);
    }
}

