/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;

@PublicEvolving
public final class DecimalType
extends LogicalType {
    public static final int MIN_PRECISION = 1;
    public static final int MAX_PRECISION = 38;
    public static final int DEFAULT_PRECISION = 10;
    public static final int MIN_SCALE = 0;
    public static final int DEFAULT_SCALE = 0;
    private static final String FORMAT = "DECIMAL(%d, %d)";
    private static final Set<String> INPUT_OUTPUT_CONVERSION = DecimalType.conversionSet(BigDecimal.class.getName(), DecimalData.class.getName());
    private static final Class<?> DEFAULT_CONVERSION = BigDecimal.class;
    private final int precision;
    private final int scale;

    public DecimalType(boolean isNullable, int precision, int scale) {
        super(isNullable, LogicalTypeRoot.DECIMAL);
        if (precision < 1 || precision > 38) {
            throw new ValidationException(String.format("Decimal precision must be between %d and %d (both inclusive).", 1, 38));
        }
        if (scale < 0 || scale > precision) {
            throw new ValidationException(String.format("Decimal scale must be between %d and the precision %d (both inclusive).", 0, precision));
        }
        this.precision = precision;
        this.scale = scale;
    }

    public DecimalType(int precision, int scale) {
        this(true, precision, scale);
    }

    public DecimalType(int precision) {
        this(precision, 0);
    }

    public DecimalType() {
        this(10);
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new DecimalType(isNullable, this.precision, this.scale);
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(FORMAT, this.precision, this.scale);
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        return INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public Class<?> getDefaultConversion() {
        return DEFAULT_CONVERSION;
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DecimalType that = (DecimalType)o;
        return this.precision == that.precision && this.scale == that.scale;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision, this.scale);
    }
}

