/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.util.Preconditions;

@Internal
public final class BuiltInFunctionDefinition
implements FunctionDefinition {
    private final String name;
    private final FunctionKind kind;
    private final TypeInference typeInference;
    private final boolean isDeterministic;

    private BuiltInFunctionDefinition(String name, FunctionKind kind, TypeInference typeInference, boolean isDeterministic) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (String)"Name must not be null.");
        this.kind = (FunctionKind)((Object)Preconditions.checkNotNull((Object)((Object)kind), (String)"Kind must not be null."));
        this.typeInference = (TypeInference)Preconditions.checkNotNull((Object)typeInference, (String)"Type inference must not be null.");
        this.isDeterministic = isDeterministic;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public FunctionKind getKind() {
        return this.kind;
    }

    @Override
    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        return this.typeInference;
    }

    @Override
    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public String toString() {
        return this.name;
    }

    public static final class Builder {
        private String name;
        private FunctionKind kind;
        private TypeInference.Builder typeInferenceBuilder = TypeInference.newBuilder();
        private boolean isDeterministic = true;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder kind(FunctionKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder namedArguments(String ... argumentNames) {
            this.typeInferenceBuilder.namedArguments(Arrays.asList(argumentNames));
            return this;
        }

        public Builder typedArguments(DataType ... argumentTypes) {
            this.typeInferenceBuilder.typedArguments(Arrays.asList(argumentTypes));
            return this;
        }

        public Builder inputTypeStrategy(InputTypeStrategy inputTypeStrategy) {
            this.typeInferenceBuilder.inputTypeStrategy(inputTypeStrategy);
            return this;
        }

        public Builder accumulatorTypeStrategy(TypeStrategy accumulatorTypeStrategy) {
            this.typeInferenceBuilder.accumulatorTypeStrategy(accumulatorTypeStrategy);
            return this;
        }

        public Builder outputTypeStrategy(TypeStrategy outputTypeStrategy) {
            this.typeInferenceBuilder.outputTypeStrategy(outputTypeStrategy);
            return this;
        }

        public Builder notDeterministic() {
            this.isDeterministic = false;
            return this;
        }

        public BuiltInFunctionDefinition build() {
            return new BuiltInFunctionDefinition(this.name, this.kind, this.typeInferenceBuilder.build(), this.isDeterministic);
        }
    }
}

