/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.bridge.scala;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@PublicEvolving
@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001E\u0011Q\u0003R1uCN#(/Z1n\u0007>tg/\u001a:tS>t7O\u0003\u0002\u0004\t\u0005)1oY1mC*\u0011QAB\u0001\u0007EJLGmZ3\u000b\u0005\u001dA\u0011aA1qS*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u0001QC\u0001\n%'\t\u00011\u0003\u0005\u0002\u0015-5\tQCC\u0001\u0004\u0013\t9RC\u0001\u0004B]f\u0014VM\u001a\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005QA-\u0019;b'R\u0014X-Y7\u0011\u0007m\u0001#%D\u0001\u001d\u0015\t\u0019QD\u0003\u0002\b=)\u0011qDC\u0001\ngR\u0014X-Y7j]\u001eL!!\t\u000f\u0003\u0015\u0011\u000bG/Y*ue\u0016\fW\u000e\u0005\u0002$I1\u0001A!B\u0013\u0001\u0005\u00041#!\u0001+\u0012\u0005\u001dR\u0003C\u0001\u000b)\u0013\tISCA\u0004O_RD\u0017N\\4\u0011\u0005QY\u0013B\u0001\u0017\u0016\u0005\r\te.\u001f\u0005\u0006]\u0001!\taL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\u0012\u0004cA\u0019\u0001E5\t!\u0001C\u0003\u001a[\u0001\u0007!\u0004C\u00035\u0001\u0011\u0005Q'A\u0004u_R\u000b'\r\\3\u0015\u0005YR\u0004CA\u001c9\u001b\u00051\u0011BA\u001d\u0007\u0005\u0015!\u0016M\u00197f\u0011\u0015Y4\u00071\u0001=\u0003!!\u0018M\u00197f\u000b:4\bCA\u0019>\u0013\tq$A\u0001\fTiJ,\u0017-\u001c+bE2,WI\u001c<je>tW.\u001a8u\u0011\u0015!\u0004\u0001\"\u0001A)\r1\u0014I\u0011\u0005\u0006w}\u0002\r\u0001\u0010\u0005\u0006\u0007~\u0002\r\u0001R\u0001\u0007g\u000eDW-\\1\u0011\u0005]*\u0015B\u0001$\u0007\u0005\u0019\u00196\r[3nC\")\u0001\n\u0001C\u0001\u0013\u0006\u00192M]3bi\u0016$V-\u001c9pe\u0006\u0014\u0018PV5foR\u0019!*\u0014(\u0011\u0005QY\u0015B\u0001'\u0016\u0005\u0011)f.\u001b;\t\u000bm:\u0005\u0019\u0001\u001f\t\u000b=;\u0005\u0019\u0001)\u0002\tA\fG\u000f\u001b\t\u0003#Rs!\u0001\u0006*\n\u0005M+\u0012A\u0002)sK\u0012,g-\u0003\u0002V-\n11\u000b\u001e:j]\u001eT!aU\u000b\t\u000b!\u0003A\u0011\u0001-\u0015\t)K&l\u0017\u0005\u0006w]\u0003\r\u0001\u0010\u0005\u0006\u001f^\u0003\r\u0001\u0015\u0005\u0006\u0007^\u0003\r\u0001\u0012\u0005\u0006;\u0002!\tAX\u0001\u0011i>\u001c\u0005.\u00198hK2|w\rV1cY\u0016$\"AN0\t\u000bmb\u0006\u0019\u0001\u001f\t\u000bu\u0003A\u0011A1\u0015\u0007Y\u00127\rC\u0003<A\u0002\u0007A\bC\u0003DA\u0002\u0007A\tC\u0003^\u0001\u0011\u0005Q\r\u0006\u00037M\u001eD\u0007\"B\u001ee\u0001\u0004a\u0004\"B\"e\u0001\u0004!\u0005\"B5e\u0001\u0004Q\u0017!D2iC:<W\r\\8h\u001b>$W\r\u0005\u0002l]6\tAN\u0003\u0002n\u0011\u0005I1m\u001c8oK\u000e$xN]\u0005\u0003_2\u0014Qb\u00115b]\u001e,Gn\\4N_\u0012,\u0007\"\u0002\u001b\u0001\t\u0003\tHc\u0001\u001csg\")1\b\u001da\u0001y!)A\u000f\u001da\u0001k\u00061a-[3mIN\u00042\u0001\u0006<y\u0013\t9XC\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002\"!\u001f?\u000e\u0003iT!a\u001f\u0005\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003{j\u0014!\"\u0012=qe\u0016\u001c8/[8oQ\t\u0001q\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)AC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0005\u0003\u0007\u0011a\u0002U;cY&\u001cWI^8mm&tw\r")
public class DataStreamConversions<T> {
    private final DataStream<T> dataStream;

    public Table toTable(StreamTableEnvironment tableEnv) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        return tableEnv.fromDataStream(this.dataStream);
    }

    public Table toTable(StreamTableEnvironment tableEnv, Schema schema) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        return tableEnv.fromDataStream(this.dataStream, schema);
    }

    public void createTemporaryView(StreamTableEnvironment tableEnv, String path) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        tableEnv.createTemporaryView(path, this.dataStream);
    }

    public void createTemporaryView(StreamTableEnvironment tableEnv, String path, Schema schema) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        tableEnv.createTemporaryView(path, this.dataStream, schema);
    }

    public Table toChangelogTable(StreamTableEnvironment tableEnv) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        Class clazz = this.dataStream.dataType().getTypeClass();
        Class<Row> clazz2 = Row.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return tableEnv.fromChangelogStream(this.dataStream);
        }
        throw new ValidationException("DataStream cannot be converted to a Table. It must contain instances of Row.");
    }

    public Table toChangelogTable(StreamTableEnvironment tableEnv, Schema schema) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        Class clazz = this.dataStream.dataType().getTypeClass();
        Class<Row> clazz2 = Row.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return tableEnv.fromChangelogStream(this.dataStream, schema);
        }
        throw new ValidationException("DataStream cannot be converted to a Table. It must contain instances of Row.");
    }

    public Table toChangelogTable(StreamTableEnvironment tableEnv, Schema schema, ChangelogMode changelogMode) {
        Preconditions.checkNotNull((Object)tableEnv, (String)"Table environment must not be null.");
        Class clazz = this.dataStream.dataType().getTypeClass();
        Class<Row> clazz2 = Row.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return tableEnv.fromChangelogStream(this.dataStream, schema, changelogMode);
        }
        throw new ValidationException("DataStream cannot be converted to a Table. It must contain instances of Row.");
    }

    public Table toTable(StreamTableEnvironment tableEnv, Seq<Expression> fields) {
        return fields.isEmpty() ? this.toTable(tableEnv) : tableEnv.fromDataStream(this.dataStream, fields);
    }

    public DataStreamConversions(DataStream<T> dataStream) {
        this.dataStream = dataStream;
    }
}

