/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.config;

import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

public class ExecutionConfigOptions {
    @Documentation.TableOption(execMode=Documentation.ExecMode.STREAMING)
    public static final ConfigOption<String> TABLE_EXEC_SOURCE_IDLE_TIMEOUT = ConfigOptions.key((String)"table.exec.source.idle-timeout").defaultValue((Object)"-1 ms").withDescription("When a source do not receive any elements for the timeout time, it will be marked as temporarily idle. This allows downstream tasks to advance their watermarks without the need to wait for watermarks from this source while it is idle.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH)
    public static final ConfigOption<Integer> TABLE_EXEC_SORT_DEFAULT_LIMIT = ConfigOptions.key((String)"table.exec.sort.default-limit").defaultValue((Object)-1).withDescription("Default limit when user don't set a limit after order by. -1 indicates that this configuration is ignored.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH)
    public static final ConfigOption<Integer> TABLE_EXEC_SORT_MAX_NUM_FILE_HANDLES = ConfigOptions.key((String)"table.exec.sort.max-num-file-handles").defaultValue((Object)128).withDescription("The maximal fan-in for external merge sort. It limits the number of file handles per operator. If it is too small, may cause intermediate merging. But if it is too large, it will cause too many files opened at the same time, consume memory and lead to random reading.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH)
    public static final ConfigOption<Boolean> TABLE_EXEC_SORT_ASYNC_MERGE_ENABLED = ConfigOptions.key((String)"table.exec.sort.async-merge-enabled").defaultValue((Object)true).withDescription("Whether to asynchronously merge sorted spill files.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH)
    public static final ConfigOption<Boolean> TABLE_EXEC_SPILL_COMPRESSION_ENABLED = ConfigOptions.key((String)"table.exec.spill-compression.enabled").defaultValue((Object)true).withDescription("Whether to compress spilled data. Currently we only support compress spilled data for sort and hash-agg and hash-join operators.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH)
    public static final ConfigOption<String> TABLE_EXEC_SPILL_COMPRESSION_BLOCK_SIZE = ConfigOptions.key((String)"table.exec.spill-compression.block-size").defaultValue((Object)"64 kb").withDescription("The memory size used to do compress when spilling data. The larger the memory, the higher the compression ratio, but more memory resource will be consumed by the job.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH_STREAMING)
    public static final ConfigOption<Integer> TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM = ConfigOptions.key((String)"table.exec.resource.default-parallelism").defaultValue((Object)-1).withDescription("Sets default parallelism for all operators (such as aggregate, join, filter) to run with parallel instances. This config has a higher priority than parallelism of StreamExecutionEnvironment (actually, this config overrides the parallelism of StreamExecutionEnvironment). A value of -1 indicates that no default parallelism is set, then it will fallback to use the parallelism of StreamExecutionEnvironment.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH)
    public static final ConfigOption<String> TABLE_EXEC_RESOURCE_EXTERNAL_BUFFER_MEMORY = ConfigOptions.key((String)"table.exec.resource.external-buffer-memory").defaultValue((Object)"10 mb").withDescription("Sets the external buffer memory size that is used in sort merge join and nested join and over window.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH)
    public static final ConfigOption<String> TABLE_EXEC_RESOURCE_HASH_AGG_MEMORY = ConfigOptions.key((String)"table.exec.resource.hash-agg.memory").defaultValue((Object)"128 mb").withDescription("Sets the managed memory size of hash aggregate operator.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH)
    public static final ConfigOption<String> TABLE_EXEC_RESOURCE_HASH_JOIN_MEMORY = ConfigOptions.key((String)"table.exec.resource.hash-join.memory").defaultValue((Object)"128 mb").withDescription("Sets the managed memory for hash join operator. It defines the lower limit.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH)
    public static final ConfigOption<String> TABLE_EXEC_RESOURCE_SORT_MEMORY = ConfigOptions.key((String)"table.exec.resource.sort.memory").defaultValue((Object)"128 mb").withDescription("Sets the managed buffer memory size for sort operator.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH)
    public static final ConfigOption<Integer> TABLE_EXEC_WINDOW_AGG_BUFFER_SIZE_LIMIT = ConfigOptions.key((String)"table.exec.window-agg.buffer-size-limit").defaultValue((Object)100000).withDescription("Sets the window elements buffer size limit used in group window agg operator.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH_STREAMING)
    public static final ConfigOption<Integer> TABLE_EXEC_ASYNC_LOOKUP_BUFFER_CAPACITY = ConfigOptions.key((String)"table.exec.async-lookup.buffer-capacity").defaultValue((Object)100).withDescription("The max number of async i/o operation that the async lookup join can trigger.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH_STREAMING)
    public static final ConfigOption<String> TABLE_EXEC_ASYNC_LOOKUP_TIMEOUT = ConfigOptions.key((String)"table.exec.async-lookup.timeout").defaultValue((Object)"3 min").withDescription("The async timeout for the asynchronous operation to complete.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.STREAMING)
    public static final ConfigOption<Boolean> TABLE_EXEC_MINIBATCH_ENABLED = ConfigOptions.key((String)"table.exec.mini-batch.enabled").defaultValue((Object)false).withDescription("Specifies whether to enable MiniBatch optimization. MiniBatch is an optimization to buffer input records to reduce state access. This is disabled by default. To enable this, users should set this config to true. NOTE: If mini-batch is enabled, 'table.exec.mini-batch.allow-latency' and 'table.exec.mini-batch.size' must be set.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.STREAMING)
    public static final ConfigOption<String> TABLE_EXEC_MINIBATCH_ALLOW_LATENCY = ConfigOptions.key((String)"table.exec.mini-batch.allow-latency").defaultValue((Object)"-1 ms").withDescription("The maximum latency can be used for MiniBatch to buffer input records. MiniBatch is an optimization to buffer input records to reduce state access. MiniBatch is triggered with the allowed latency interval and when the maximum number of buffered records reached. NOTE: If " + TABLE_EXEC_MINIBATCH_ENABLED.key() + " is set true, its value must be greater than zero.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.STREAMING)
    public static final ConfigOption<Long> TABLE_EXEC_MINIBATCH_SIZE = ConfigOptions.key((String)"table.exec.mini-batch.size").defaultValue((Object)-1L).withDescription("The maximum number of input records can be buffered for MiniBatch. MiniBatch is an optimization to buffer input records to reduce state access. MiniBatch is triggered with the allowed latency interval and when the maximum number of buffered records reached. NOTE: MiniBatch only works for non-windowed aggregations currently. If " + TABLE_EXEC_MINIBATCH_ENABLED.key() + " is set true, its value must be positive.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH)
    public static final ConfigOption<String> TABLE_EXEC_DISABLED_OPERATORS = ConfigOptions.key((String)"table.exec.disabled-operators").noDefaultValue().withDescription("Mainly for testing. A comma-separated list of operator names, each name represents a kind of disabled operator.\nOperators that can be disabled include \"NestedLoopJoin\", \"ShuffleHashJoin\", \"BroadcastHashJoin\", \"SortMergeJoin\", \"HashAgg\", \"SortAgg\".\nBy default no operator is disabled.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH)
    public static final ConfigOption<String> TABLE_EXEC_SHUFFLE_MODE = ConfigOptions.key((String)"table.exec.shuffle-mode").defaultValue((Object)"batch").withDescription("Sets exec shuffle mode. Only batch or pipeline can be set.\nbatch: the job will run stage by stage. \npipeline: the job will run in streaming mode, but it may cause resource deadlock that receiver waits for resource to start when the sender holds resource to wait to send data to the receiver.");
}

