/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.datagen.table;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.datagen.table.types.RowDataGenerator;
import org.apache.flink.streaming.api.functions.source.datagen.DataGenerator;
import org.apache.flink.streaming.api.functions.source.datagen.DataGeneratorSource;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.abilities.SupportsLimitPushDown;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;

@Internal
public class DataGenTableSource
implements ScanTableSource,
SupportsLimitPushDown {
    private final DataGenerator<?>[] fieldGenerators;
    private final String tableName;
    private final DataType rowDataType;
    private final long rowsPerSecond;
    private Long numberOfRows;
    @Nullable
    private final Integer parallelism;

    public DataGenTableSource(DataGenerator<?>[] fieldGenerators, String tableName, DataType rowDataType, long rowsPerSecond, Long numberOfRows, Integer parallelism) {
        this.fieldGenerators = fieldGenerators;
        this.tableName = tableName;
        this.rowDataType = rowDataType;
        this.rowsPerSecond = rowsPerSecond;
        this.numberOfRows = numberOfRows;
        this.parallelism = parallelism;
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext context) {
        boolean isBounded = this.numberOfRows != null;
        return SourceFunctionProvider.of(this.createSource(), isBounded, this.parallelism);
    }

    @VisibleForTesting
    public DataGeneratorSource<RowData> createSource() {
        return new DataGeneratorSource((DataGenerator)new RowDataGenerator(this.fieldGenerators, DataType.getFieldNames((DataType)this.rowDataType), 0.0f), this.rowsPerSecond, this.numberOfRows);
    }

    public DynamicTableSource copy() {
        return new DataGenTableSource(this.fieldGenerators, this.tableName, this.rowDataType, this.rowsPerSecond, this.numberOfRows, this.parallelism);
    }

    public String asSummaryString() {
        return "DataGenTableSource";
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    public void applyLimit(long limit) {
        this.numberOfRows = limit;
    }
}

