/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.SourceReaderOperator;
import org.apache.flink.streaming.runtime.io.InputStatus;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.io.StreamTaskInput;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

@Internal
public final class StreamTaskSourceInput<T>
implements StreamTaskInput<T> {
    private final SourceReaderOperator<T> operator;

    public StreamTaskSourceInput(SourceReaderOperator<T> operator) {
        this.operator = (SourceReaderOperator)Preconditions.checkNotNull(operator);
    }

    @Override
    public InputStatus emitNext(PushingAsyncDataInput.DataOutput<T> output) throws Exception {
        return this.operator.emitNext(output);
    }

    public CompletableFuture<?> getAvailableFuture() {
        return this.operator.getAvailableFuture();
    }

    @Override
    public int getInputIndex() {
        return -1;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.operator::close);
    }
}

