/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.Optional;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.streaming.runtime.io.BufferStorage;

public class LinkedBufferStorage
implements BufferStorage {
    private final BufferStorage mainStorage;
    private final BufferStorage linkedStorage;
    private long maxBufferedBytes;

    public LinkedBufferStorage(BufferStorage mainStorage, BufferStorage linkedStorage, long maxBufferedBytes) {
        this.mainStorage = mainStorage;
        this.linkedStorage = linkedStorage;
        this.maxBufferedBytes = maxBufferedBytes;
    }

    @Override
    public void add(BufferOrEvent boe) {
        this.mainStorage.add(boe);
    }

    @Override
    public boolean isFull() {
        return this.maxBufferedBytes > 0L && this.getRolledBytes() + this.getPendingBytes() > this.maxBufferedBytes;
    }

    @Override
    public void rollOver() {
        this.mainStorage.rollOver();
        this.linkedStorage.rollOver();
    }

    @Override
    public long getPendingBytes() {
        return this.mainStorage.getPendingBytes() + this.linkedStorage.getPendingBytes();
    }

    @Override
    public long getRolledBytes() {
        return this.mainStorage.getRolledBytes() + this.linkedStorage.getRolledBytes();
    }

    @Override
    public boolean isEmpty() {
        return this.mainStorage.isEmpty();
    }

    @Override
    public Optional<BufferOrEvent> pollNext() {
        return this.mainStorage.pollNext();
    }

    @Override
    public long getMaxBufferedBytes() {
        return this.maxBufferedBytes;
    }

    @Override
    public void close() {
        this.mainStorage.close();
    }
}

