/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.client.program.ContextEnvironment;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.core.execution.DetachedJobExecutionResult;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ShutdownHookUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class StreamContextEnvironment
extends StreamExecutionEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionEnvironment.class);
    private final ContextEnvironment ctx;

    StreamContextEnvironment(ContextEnvironment ctx) {
        super(((ContextEnvironment)Preconditions.checkNotNull((Object)ctx)).getExecutorServiceLoader(), ctx.getConfiguration(), ctx.getUserCodeClassLoader());
        this.ctx = ctx;
        int parallelism = ctx.getParallelism();
        if (parallelism > 0) {
            this.setParallelism(parallelism);
        }
    }

    @Override
    public JobExecutionResult execute(StreamGraph streamGraph) throws Exception {
        DetachedJobExecutionResult jobExecutionResult;
        JobClient jobClient = this.executeAsync(streamGraph);
        if (this.getConfiguration().getBoolean(DeploymentOptions.ATTACHED)) {
            CompletableFuture jobExecutionResultFuture = jobClient.getJobExecutionResult(this.ctx.getUserCodeClassLoader());
            if (this.getConfiguration().getBoolean(DeploymentOptions.SHUTDOWN_IF_ATTACHED)) {
                Thread shutdownHook = ShutdownHookUtil.addShutdownHook(() -> jobClient.cancel().get(1L, TimeUnit.SECONDS), (String)ContextEnvironment.class.getSimpleName(), (Logger)LOG);
                jobExecutionResultFuture.whenComplete((ignored, throwable) -> ShutdownHookUtil.removeShutdownHook((Thread)shutdownHook, (String)ContextEnvironment.class.getSimpleName(), (Logger)LOG));
            }
            jobExecutionResult = (JobExecutionResult)jobExecutionResultFuture.get();
            System.out.println(jobExecutionResult);
        } else {
            jobExecutionResult = new DetachedJobExecutionResult(jobClient.getJobID());
        }
        return jobExecutionResult;
    }

    @Override
    public JobClient executeAsync(StreamGraph streamGraph) throws Exception {
        JobClient jobClient = super.executeAsync(streamGraph);
        System.out.println("Job has been submitted with JobID " + jobClient.getJobID());
        return jobClient;
    }
}

