/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.SupportsConcurrentExecutionAttempts;
import org.apache.flink.api.common.functions.util.PrintSinkOutputWriter;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.api.connector.sink2.WriterInitContext;

@PublicEvolving
public class PrintSink<IN>
implements Sink<IN>,
SupportsConcurrentExecutionAttempts {
    private static final long serialVersionUID = 1L;
    private final String sinkIdentifier;
    private final boolean isStdErr;

    public PrintSink() {
        this("");
    }

    public PrintSink(boolean isStdErr) {
        this("", isStdErr);
    }

    public PrintSink(String sinkIdentifier) {
        this(sinkIdentifier, false);
    }

    public PrintSink(String sinkIdentifier, boolean isStdErr) {
        this.sinkIdentifier = sinkIdentifier;
        this.isStdErr = isStdErr;
    }

    public SinkWriter<IN> createWriter(WriterInitContext context) throws IOException {
        PrintSinkOutputWriter writer = new PrintSinkOutputWriter(this.sinkIdentifier, this.isStdErr);
        writer.open(context.getTaskInfo().getIndexOfThisSubtask(), context.getTaskInfo().getNumberOfParallelSubtasks());
        return writer;
    }

    public String toString() {
        return "Print to " + (this.isStdErr ? "System.err" : "System.out");
    }
}

