/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.streaming.api.windowing.assigners.GlobalWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.windows.GlobalWindow;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class GlobalWindowsTest {
    GlobalWindowsTest() {
    }

    @Test
    void testWindowAssignment() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        GlobalWindows assigner = GlobalWindows.create();
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 0L, mockContext)).containsExactly((Object[])new GlobalWindow[]{GlobalWindow.get()});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 4999L, mockContext)).containsExactly((Object[])new GlobalWindow[]{GlobalWindow.get()});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 5000L, mockContext)).containsExactly((Object[])new GlobalWindow[]{GlobalWindow.get()});
    }

    @Test
    void testProperties() {
        GlobalWindows assigner = GlobalWindows.create();
        Assertions.assertThat((boolean)assigner.isEventTime()).isFalse();
        Assertions.assertThat((Object)assigner.getWindowSerializer(new ExecutionConfig())).isEqualTo((Object)new GlobalWindow.Serializer());
        Assertions.assertThat((Object)assigner.getDefaultTrigger()).isInstanceOf(GlobalWindows.NeverTrigger.class);
        assigner = GlobalWindows.createWithEndOfStreamTrigger();
        Assertions.assertThat((Object)assigner.getDefaultTrigger()).isInstanceOf(GlobalWindows.EndOfStreamTrigger.class);
    }
}

