/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators;

import java.util.ArrayList;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.testutils.DummyEnvironment;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.functions.source.RichSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.api.operators.StreamSourceContexts;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.SourceStreamTask;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.tasks.StreamTaskTestHarness;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.TimerService;
import org.apache.flink.streaming.util.CollectorOutput;
import org.apache.flink.streaming.util.MockStreamTask;
import org.apache.flink.streaming.util.MockStreamTaskBuilder;
import org.apache.flink.util.ExceptionUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class StreamSourceOperatorWatermarksTest {
    StreamSourceOperatorWatermarksTest() {
    }

    @Test
    void testEmitMaxWatermarkForFiniteSource() throws Exception {
        StreamSource sourceOperator = new StreamSource(new FiniteSource());
        StreamTaskTestHarness testHarness = StreamSourceOperatorWatermarksTest.setupSourceStreamTask(sourceOperator, BasicTypeInfo.STRING_TYPE_INFO);
        testHarness.invoke();
        testHarness.waitForTaskCompletion();
        Assertions.assertThat(testHarness.getOutput()).hasSize(1);
        Assertions.assertThat((Object)testHarness.getOutput().peek()).isEqualTo((Object)Watermark.MAX_WATERMARK);
    }

    @Test
    void testDisabledProgressiveWatermarksForFiniteSource() throws Exception {
        StreamSource sourceOperator = new StreamSource(new FiniteSourceWithWatermarks(), false);
        StreamTaskTestHarness testHarness = StreamSourceOperatorWatermarksTest.setupSourceStreamTask(sourceOperator, BasicTypeInfo.STRING_TYPE_INFO);
        testHarness.invoke();
        testHarness.waitForTaskCompletion();
        Assertions.assertThat((Object)testHarness.getOutput().poll()).isEqualTo((Object)Watermark.MAX_WATERMARK);
        Assertions.assertThat((Object)testHarness.getOutput().poll()).isEqualTo((Object)Watermark.MAX_WATERMARK);
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
    }

    @Test
    void testNoMaxWatermarkOnImmediateCancel() throws Exception {
        StreamSource sourceOperator = new StreamSource(new InfiniteSource());
        StreamTaskTestHarness testHarness = StreamSourceOperatorWatermarksTest.setupSourceStreamTask(sourceOperator, BasicTypeInfo.STRING_TYPE_INFO, true);
        testHarness.invoke();
        Assertions.assertThatThrownBy(testHarness::waitForTaskCompletion).hasCauseInstanceOf(CancelTaskException.class);
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
    }

    @Test
    void testNoMaxWatermarkOnAsyncCancel() throws Exception {
        StreamTaskTestHarness testHarness;
        block2: {
            StreamSource sourceOperator = new StreamSource(new InfiniteSource());
            testHarness = StreamSourceOperatorWatermarksTest.setupSourceStreamTask(sourceOperator, BasicTypeInfo.STRING_TYPE_INFO);
            testHarness.invoke();
            testHarness.waitForTaskRunning();
            Thread.sleep(200L);
            testHarness.getTask().cancel();
            try {
                testHarness.waitForTaskCompletion();
            }
            catch (Throwable t) {
                if (ExceptionUtils.findThrowable((Throwable)t, CancelTaskException.class).isPresent()) break block2;
                throw t;
            }
        }
        Assertions.assertThat(testHarness.getOutput()).isEmpty();
    }

    @Test
    void testAutomaticWatermarkContext() throws Exception {
        StreamSource operator = new StreamSource(new InfiniteSource());
        long watermarkInterval = 10L;
        TestProcessingTimeService processingTimeService = new TestProcessingTimeService();
        processingTimeService.setCurrentTime(0L);
        MockStreamTask task = StreamSourceOperatorWatermarksTest.setupSourceOperator(operator, TimeCharacteristic.IngestionTime, watermarkInterval, (TimerService)processingTimeService);
        ArrayList<StreamElement> output = new ArrayList<StreamElement>();
        StreamSourceContexts.getSourceContext((TimeCharacteristic)TimeCharacteristic.IngestionTime, (ProcessingTimeService)processingTimeService, (Object)task.getCheckpointLock(), new CollectorOutput(output), (long)operator.getExecutionConfig().getAutoWatermarkInterval(), (long)-1L, (boolean)true);
        for (long i = 1L; i < 100L; i += watermarkInterval) {
            processingTimeService.setCurrentTime(i);
        }
        Assertions.assertThat(output).hasSize(9);
        long nextWatermark = 0L;
        for (StreamElement el : output) {
            Watermark wm = (Watermark)el;
            Assertions.assertThat((long)wm.getTimestamp()).isEqualTo(nextWatermark += watermarkInterval);
        }
    }

    private static <T> MockStreamTask setupSourceOperator(StreamSource<T, ?> operator, TimeCharacteristic timeChar, long watermarkInterval, TimerService timeProvider) throws Exception {
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.setAutoWatermarkInterval(watermarkInterval);
        StreamConfig cfg = new StreamConfig(new Configuration());
        cfg.setStateBackend((StateBackend)new MemoryStateBackend());
        cfg.setTimeCharacteristic(timeChar);
        cfg.setOperatorID(new OperatorID());
        DummyEnvironment env = new DummyEnvironment("MockTwoInputTask", 1, 0);
        MockStreamTask mockTask = new MockStreamTaskBuilder((Environment)env).setConfig(cfg).setExecutionConfig(executionConfig).setTimerService(timeProvider).build();
        operator.setup((StreamTask)mockTask, cfg, (Output)Mockito.mock(Output.class));
        return mockTask;
    }

    private static <T> StreamTaskTestHarness<T> setupSourceStreamTask(StreamSource<T, ?> sourceOperator, TypeInformation<T> outputType) {
        return StreamSourceOperatorWatermarksTest.setupSourceStreamTask(sourceOperator, outputType, false);
    }

    private static <T> StreamTaskTestHarness<T> setupSourceStreamTask(StreamSource<T, ?> sourceOperator, TypeInformation<T> outputType, boolean cancelImmediatelyAfterCreation) {
        StreamTaskTestHarness<T> testHarness = new StreamTaskTestHarness<T>(env -> {
            SourceStreamTask sourceTask = new SourceStreamTask(env);
            if (cancelImmediatelyAfterCreation) {
                try {
                    sourceTask.cancel();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return sourceTask;
        }, outputType);
        testHarness.setupOutputForSingletonOperatorChain();
        StreamConfig streamConfig = testHarness.getStreamConfig();
        streamConfig.setStreamOperator(sourceOperator);
        streamConfig.setOperatorID(new OperatorID());
        streamConfig.setTimeCharacteristic(TimeCharacteristic.EventTime);
        return testHarness;
    }

    private static final class InfiniteSource<T>
    implements SourceFunction<T> {
        private volatile boolean running = true;

        private InfiniteSource() {
        }

        public void run(SourceFunction.SourceContext<T> ctx) throws Exception {
            while (this.running) {
                Thread.sleep(20L);
            }
        }

        public void cancel() {
            this.running = false;
        }
    }

    private static final class FiniteSourceWithWatermarks<T>
    extends RichSourceFunction<T> {
        private FiniteSourceWithWatermarks() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(SourceFunction.SourceContext<T> ctx) {
            Object object = ctx.getCheckpointLock();
            synchronized (object) {
                ctx.emitWatermark(new Watermark(1000L));
                ctx.emitWatermark(new Watermark(2000L));
                ctx.emitWatermark(Watermark.MAX_WATERMARK);
            }
        }

        public void cancel() {
        }
    }

    private static final class FiniteSource<T>
    extends RichSourceFunction<T> {
        private FiniteSource() {
        }

        public void run(SourceFunction.SourceContext<T> ctx) {
        }

        public void cancel() {
        }
    }
}

