/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.benchmark;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.api.writer.RecordWriterBuilder;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.streaming.runtime.io.benchmark.ReceiverThread;
import org.apache.flink.streaming.runtime.io.benchmark.StreamNetworkBenchmarkEnvironment;
import org.apache.flink.types.LongValue;

public class StreamNetworkPointToPointBenchmark {
    private static final long RECEIVER_TIMEOUT = 2000L;
    private StreamNetworkBenchmarkEnvironment<LongValue> environment;
    private ReceiverThread receiver;
    private RecordWriter<LongValue> recordWriter;

    public void executeBenchmark(long records, boolean flushAfterLastEmit) throws Exception {
        LongValue value = new LongValue();
        value.setValue(0L);
        CompletableFuture<?> recordsReceived = this.receiver.setExpectedRecord(records);
        int i = 1;
        while ((long)i < records) {
            this.recordWriter.emit((IOReadableWritable)value);
            ++i;
        }
        value.setValue(records);
        this.recordWriter.broadcastEmit((IOReadableWritable)value);
        if (flushAfterLastEmit) {
            this.recordWriter.flushAll();
        }
        recordsReceived.get(2000L, TimeUnit.MILLISECONDS);
    }

    public void setUp(long flushTimeout) throws Exception {
        this.setUp(flushTimeout, new Configuration());
    }

    public void setUp(long flushTimeout, Configuration config) throws Exception {
        this.environment = new StreamNetworkBenchmarkEnvironment();
        this.environment.setUp(1, 1, false, -1, -1, config);
        ResultPartitionWriter resultPartitionWriter = this.environment.createResultPartitionWriter(0);
        this.recordWriter = new RecordWriterBuilder().setTimeout(flushTimeout).build(resultPartitionWriter);
        this.receiver = this.environment.createReceiver();
    }

    public void tearDown() {
        this.environment.tearDown();
        this.receiver.shutdown();
    }
}

