/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.graph;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.util.MockStreamConfig;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;

class StreamConfigTest {
    StreamConfigTest() {
    }

    @Test
    void testClearInitialConfigs() {
        int chainedTaskId = 3456;
        MockStreamConfig streamConfig = new MockStreamConfig(new Configuration(), 1, Collections.singletonMap(chainedTaskId, new MockStreamConfig(new Configuration(), 1)));
        ClassLoader classLoader = this.getClass().getClassLoader();
        StreamOperatorFactory streamOperatorFactory = streamConfig.getStreamOperatorFactory(classLoader);
        Assertions.assertThat((Object)streamOperatorFactory).isNotNull();
        Assertions.assertThat((Class)streamConfig.getStreamOperatorFactoryClass(classLoader)).isNotNull();
        ((MapAssert)Assertions.assertThat((Map)streamConfig.getTransitiveChainedTaskConfigs(classLoader)).hasSize(1)).containsKey((Object)chainedTaskId);
        streamConfig.clearInitialConfigs();
        Assertions.assertThatThrownBy(() -> streamConfig.getStreamOperatorFactory(classLoader)).hasCauseInstanceOf(IllegalStateException.class).hasRootCauseMessage("serializedUDF has been removed.");
        Assertions.assertThat((Class)streamConfig.getStreamOperatorFactoryClass(classLoader)).isNotNull();
        Assertions.assertThatThrownBy(() -> streamConfig.getTransitiveChainedTaskConfigs(classLoader)).hasCauseInstanceOf(IllegalStateException.class).hasRootCauseMessage("chainedTaskConfig_ has been removed.");
    }
}

