/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions;

import org.apache.flink.streaming.api.functions.timestamps.AscendingTimestampExtractor;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AscendingTimestampExtractorTest {
    AscendingTimestampExtractorTest() {
    }

    @Test
    void testWithFailingHandler() {
        AscendingTimestampExtractor extractor = new LongExtractor().withViolationHandler((AscendingTimestampExtractor.MonotonyViolationHandler)new AscendingTimestampExtractor.FailingHandler());
        this.runValidTests((AscendingTimestampExtractor<Long>)extractor);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runInvalidTest((AscendingTimestampExtractor<Long>)extractor)).isInstanceOf(RuntimeException.class)).hasMessageContaining("Ascending timestamps condition violated.");
    }

    @Test
    void testWithIgnoringHandler() {
        AscendingTimestampExtractor extractor = new LongExtractor().withViolationHandler((AscendingTimestampExtractor.MonotonyViolationHandler)new AscendingTimestampExtractor.IgnoringHandler());
        this.runValidTests((AscendingTimestampExtractor<Long>)extractor);
        this.runInvalidTest((AscendingTimestampExtractor<Long>)extractor);
    }

    @Test
    void testWithLoggingHandler() {
        AscendingTimestampExtractor extractor = new LongExtractor().withViolationHandler((AscendingTimestampExtractor.MonotonyViolationHandler)new AscendingTimestampExtractor.LoggingHandler());
        this.runValidTests((AscendingTimestampExtractor<Long>)extractor);
        this.runInvalidTest((AscendingTimestampExtractor<Long>)extractor);
    }

    @Test
    void testWithDefaultHandler() {
        LongExtractor extractor = new LongExtractor();
        this.runValidTests(extractor);
        this.runInvalidTest(extractor);
    }

    @Test
    void testInitialAndFinalWatermark() {
        LongExtractor extractor = new LongExtractor();
        Assertions.assertThat((long)extractor.getCurrentWatermark().getTimestamp()).isEqualTo(Long.MIN_VALUE);
        extractor.extractTimestamp(Long.MIN_VALUE, -1L);
        extractor.extractTimestamp(Long.MAX_VALUE, -1L);
        Assertions.assertThat((long)extractor.getCurrentWatermark().getTimestamp()).isEqualTo(0x7FFFFFFFFFFFFFFEL);
    }

    private void runValidTests(AscendingTimestampExtractor<Long> extractor) {
        Assertions.assertThat((long)extractor.extractTimestamp((Object)13L, -1L)).isEqualTo(13L);
        Assertions.assertThat((long)extractor.extractTimestamp((Object)13L, 0L)).isEqualTo(13L);
        Assertions.assertThat((long)extractor.extractTimestamp((Object)14L, 0L)).isEqualTo(14L);
        Assertions.assertThat((long)extractor.extractTimestamp((Object)20L, 0L)).isEqualTo(20L);
        Assertions.assertThat((long)extractor.extractTimestamp((Object)20L, 0L)).isEqualTo(20L);
        Assertions.assertThat((long)extractor.extractTimestamp((Object)20L, 0L)).isEqualTo(20L);
        Assertions.assertThat((long)extractor.extractTimestamp((Object)500L, 0L)).isEqualTo(500L);
        Assertions.assertThat((long)extractor.extractTimestamp((Object)0x7FFFFFFFFFFFFFFEL, 99999L)).isEqualTo(0x7FFFFFFFFFFFFFFEL);
    }

    private void runInvalidTest(AscendingTimestampExtractor<Long> extractor) {
        Assertions.assertThat((long)extractor.extractTimestamp((Object)1000L, 100L)).isEqualTo(1000L);
        Assertions.assertThat((long)extractor.extractTimestamp((Object)1000L, 100L)).isEqualTo(1000L);
        Assertions.assertThat((long)extractor.extractTimestamp((Object)999L, 100L)).isEqualTo(999L);
    }

    private static class LongExtractor
    extends AscendingTimestampExtractor<Long> {
        private static final long serialVersionUID = 1L;

        private LongExtractor() {
        }

        public long extractAscendingTimestamp(Long element) {
            return element;
        }
    }
}

