/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

class RestartStrategyTest {
    RestartStrategyTest() {
    }

    @Test
    void testFallbackStrategyOnClientSideWhenCheckpointingEnabled() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.enableCheckpointing(500L);
        env.fromData((Object[])new Integer[]{1}).print();
        StreamGraph graph = env.getStreamGraph();
        JobGraph jobGraph = graph.getJobGraph();
        RestartStrategies.RestartStrategyConfiguration restartStrategy = ((ExecutionConfig)jobGraph.getSerializedExecutionConfig().deserializeValue(this.getClass().getClassLoader())).getRestartStrategy();
        ((ObjectAssert)Assertions.assertThat((Object)restartStrategy).isNotNull()).isInstanceOf(RestartStrategies.FallbackRestartStrategyConfiguration.class);
    }

    @Test
    void testNoRestartingWhenCheckpointingAndExplicitExecutionRetriesZero() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.enableCheckpointing(500L);
        env.setNumberOfExecutionRetries(0);
        env.fromData((Object[])new Integer[]{1}).print();
        StreamGraph graph = env.getStreamGraph();
        JobGraph jobGraph = graph.getJobGraph();
        RestartStrategies.RestartStrategyConfiguration restartStrategy = ((ExecutionConfig)jobGraph.getSerializedExecutionConfig().deserializeValue(this.getClass().getClassLoader())).getRestartStrategy();
        ((ObjectAssert)Assertions.assertThat((Object)restartStrategy).isNotNull()).isInstanceOf(RestartStrategies.NoRestartStrategyConfiguration.class);
    }

    @Test
    void testFixedRestartingWhenCheckpointingAndExplicitExecutionRetriesNonZero() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.enableCheckpointing(500L);
        env.setNumberOfExecutionRetries(42);
        env.getConfig().setExecutionRetryDelay(1337L);
        env.fromData((Object[])new Integer[]{1}).print();
        StreamGraph graph = env.getStreamGraph();
        JobGraph jobGraph = graph.getJobGraph();
        RestartStrategies.RestartStrategyConfiguration restartStrategy = ((ExecutionConfig)jobGraph.getSerializedExecutionConfig().deserializeValue(this.getClass().getClassLoader())).getRestartStrategy();
        ((ObjectAssert)Assertions.assertThat((Object)restartStrategy).isNotNull()).isInstanceOfSatisfying(RestartStrategies.FixedDelayRestartStrategyConfiguration.class, strategy -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)strategy).satisfies(new ThrowingConsumer[]{fixedDelayRestartStrategy -> {
                Assertions.assertThat((int)fixedDelayRestartStrategy.getRestartAttempts()).isEqualTo(42);
                Assertions.assertThat((long)fixedDelayRestartStrategy.getDurationBetweenAttempts().toMillis()).isEqualTo(1337L);
            }});
        });
    }
}

