/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.util;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.TimestampAssigner;
import org.apache.flink.api.common.eventtime.TimestampAssignerSupplier;
import org.apache.flink.api.common.eventtime.WatermarkGenerator;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.eventtime.WatermarkOutput;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.streaming.api.functions.AssignerWithPeriodicWatermarks;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.util.Preconditions;

@Internal
public final class AssignerWithPeriodicWatermarksAdapter<T>
implements WatermarkGenerator<T> {
    private final AssignerWithPeriodicWatermarks<T> wms;

    public AssignerWithPeriodicWatermarksAdapter(AssignerWithPeriodicWatermarks<T> wms) {
        this.wms = (AssignerWithPeriodicWatermarks)Preconditions.checkNotNull(wms);
    }

    public void onEvent(T event, long eventTimestamp, WatermarkOutput output) {
    }

    public void onPeriodicEmit(WatermarkOutput output) {
        Watermark next = this.wms.getCurrentWatermark();
        if (next != null) {
            output.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(next.getTimestamp()));
        }
    }

    public static final class Strategy<T>
    implements WatermarkStrategy<T> {
        private static final long serialVersionUID = 1L;
        private final AssignerWithPeriodicWatermarks<T> wms;

        public Strategy(AssignerWithPeriodicWatermarks<T> wms) {
            this.wms = (AssignerWithPeriodicWatermarks)Preconditions.checkNotNull(wms);
        }

        public TimestampAssigner<T> createTimestampAssigner(TimestampAssignerSupplier.Context context) {
            return this.wms;
        }

        public WatermarkGenerator<T> createWatermarkGenerator(WatermarkGeneratorSupplier.Context context) {
            return new AssignerWithPeriodicWatermarksAdapter<T>(this.wms);
        }
    }
}

