/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.translators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.graph.SimpleTransformationTranslator;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.api.transformations.SideOutputTransformation;
import org.apache.flink.util.Preconditions;

@Internal
public class SideOutputTransformationTranslator<OUT>
extends SimpleTransformationTranslator<OUT, SideOutputTransformation<OUT>> {
    @Override
    protected Collection<Integer> translateForBatchInternal(SideOutputTransformation<OUT> transformation, TransformationTranslator.Context context) {
        return this.translateInternal(transformation, context);
    }

    @Override
    protected Collection<Integer> translateForStreamingInternal(SideOutputTransformation<OUT> transformation, TransformationTranslator.Context context) {
        return this.translateInternal(transformation, context);
    }

    private Collection<Integer> translateInternal(SideOutputTransformation<OUT> transformation, TransformationTranslator.Context context) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull((Object)context);
        StreamGraph streamGraph = context.getStreamGraph();
        List<Transformation<?>> parentTransformations = transformation.getInputs();
        Preconditions.checkState((parentTransformations.size() == 1 ? 1 : 0) != 0, (Object)("Expected exactly one input transformation but found " + parentTransformations.size()));
        ArrayList<Integer> virtualResultIds = new ArrayList<Integer>();
        Transformation<?> parentTransformation = parentTransformations.get(0);
        for (int inputId : context.getStreamNodeIds(parentTransformation)) {
            int virtualId = Transformation.getNewNodeId();
            streamGraph.addVirtualSideOutputNode(inputId, virtualId, transformation.getOutputTag());
            virtualResultIds.add(virtualId);
        }
        return virtualResultIds;
    }
}

