/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueElement;
import org.apache.flink.streaming.api.operators.InternalTimer;

@Internal
public final class TimerHeapInternalTimer<K, N>
implements InternalTimer<K, N>,
HeapPriorityQueueElement {
    @Nonnull
    private final K key;
    @Nonnull
    private final N namespace;
    private final long timestamp;
    private transient int timerHeapIndex;

    public TimerHeapInternalTimer(long timestamp, @Nonnull K key, @Nonnull N namespace) {
        this.timestamp = timestamp;
        this.key = key;
        this.namespace = namespace;
        this.timerHeapIndex = Integer.MIN_VALUE;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    @Nonnull
    public K getKey() {
        return this.key;
    }

    @Override
    @Nonnull
    public N getNamespace() {
        return this.namespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalTimer) {
            InternalTimer timer = (InternalTimer)o;
            return this.timestamp == timer.getTimestamp() && this.key.equals(timer.getKey()) && this.namespace.equals(timer.getNamespace());
        }
        return false;
    }

    public int getInternalIndex() {
        return this.timerHeapIndex;
    }

    public void setInternalIndex(int newIndex) {
        this.timerHeapIndex = newIndex;
    }

    void removedFromTimerQueue() {
        this.setInternalIndex(Integer.MIN_VALUE);
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.namespace.hashCode();
        return result;
    }

    public String toString() {
        return "Timer{timestamp=" + this.timestamp + ", key=" + this.key + ", namespace=" + this.namespace + '}';
    }

    public int comparePriorityTo(@Nonnull InternalTimer<?, ?> other) {
        return Long.compare(this.timestamp, other.getTimestamp());
    }
}

