/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.DiscardingSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.api.transformations.StreamExchangeMode;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;

public class StreamPartitionerTestUtils {
    public static JobGraph createJobGraph(String sourceSlotSharingGroup, String sinkSlotSharingGroup, StreamPartitioner<Long> streamPartitioner) {
        return StreamPartitionerTestUtils.createJobGraph(sourceSlotSharingGroup, sinkSlotSharingGroup, streamPartitioner, StreamExchangeMode.UNDEFINED);
    }

    public static JobGraph createJobGraph(String sourceSlotSharingGroup, String sinkSlotSharingGroup, StreamPartitioner<Long> streamPartitioner, StreamExchangeMode exchangeMode) {
        Configuration configuration = new Configuration();
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)configuration);
        env.setRuntimeMode(RuntimeExecutionMode.BATCH);
        SingleOutputStreamOperator source = env.fromSequence(0L, 99L).slotSharingGroup(sourceSlotSharingGroup).name("source");
        StreamPartitionerTestUtils.setPartitioner(source, streamPartitioner, exchangeMode).addSink((SinkFunction)new DiscardingSink()).slotSharingGroup(sinkSlotSharingGroup).name("sink");
        return env.getStreamGraph().getJobGraph();
    }

    private static <T> DataStream<T> setPartitioner(DataStream<T> dataStream, StreamPartitioner<T> partitioner, StreamExchangeMode exchangeMode) {
        return new DataStream(dataStream.getExecutionEnvironment(), (Transformation)new PartitionTransformation(dataStream.getTransformation(), partitioner, exchangeMode));
    }

    private StreamPartitionerTestUtils() {
    }
}

