/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.OptionalLong;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.operators.ProcessingTimeService;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.SinkWriterMetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.metrics.groups.InternalSinkWriterMetricGroup;
import org.apache.flink.streaming.api.functions.sink.PrintSink;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.SimpleUserCodeClassLoader;
import org.apache.flink.util.UserCodeClassLoader;
import org.apache.flink.util.function.ThrowingRunnable;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PrintSinkTest {
    private final PrintStream originalSystemOut = System.out;
    private final PrintStream originalSystemErr = System.err;
    private final ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
    private final ByteArrayOutputStream arrayErrorStream = new ByteArrayOutputStream();
    private final String line = System.lineSeparator();

    PrintSinkTest() {
    }

    @BeforeEach
    void setUp() {
        System.setOut(new PrintStream(this.arrayOutputStream));
        System.setErr(new PrintStream(this.arrayErrorStream));
    }

    @AfterEach
    void tearDown() {
        if (System.out != this.originalSystemOut) {
            System.out.close();
        }
        if (System.err != this.originalSystemErr) {
            System.err.close();
        }
        System.setOut(this.originalSystemOut);
        System.setErr(this.originalSystemErr);
    }

    @Test
    void testPrintSinkStdOut() throws Exception {
        PrintSink printSink = new PrintSink();
        try (SinkWriter writer = printSink.createWriter((Sink.InitContext)new MockInitContext(1));){
            writer.write((Object)"hello world!", (SinkWriter.Context)new MockContext());
            Assert.assertEquals((Object)"Print to System.out", (Object)printSink.toString());
            Assert.assertEquals((Object)("hello world!" + this.line), (Object)this.arrayOutputStream.toString());
        }
    }

    @Test
    void testPrintSinkStdErr() throws Exception {
        PrintSink printSink = new PrintSink(true);
        try (SinkWriter writer = printSink.createWriter((Sink.InitContext)new MockInitContext(1));){
            writer.write((Object)"hello world!", (SinkWriter.Context)new MockContext());
            Assert.assertEquals((Object)"Print to System.err", (Object)printSink.toString());
            Assert.assertEquals((Object)("hello world!" + this.line), (Object)this.arrayErrorStream.toString());
        }
    }

    @Test
    void testPrintSinkStdErrWithIdentifier() throws Exception {
        PrintSink printSink = new PrintSink("mySink", true);
        try (SinkWriter writer = printSink.createWriter((Sink.InitContext)new MockInitContext(1));){
            writer.write((Object)"hello world!", (SinkWriter.Context)new MockContext());
            Assert.assertEquals((Object)"Print to System.err", (Object)printSink.toString());
            Assert.assertEquals((Object)("mySink> hello world!" + this.line), (Object)this.arrayErrorStream.toString());
        }
    }

    @Test
    void testPrintSinkWithPrefix() throws Exception {
        PrintSink printSink = new PrintSink();
        try (SinkWriter writer = printSink.createWriter((Sink.InitContext)new MockInitContext(2));){
            writer.write((Object)"hello world!", (SinkWriter.Context)new MockContext());
            Assert.assertEquals((Object)"Print to System.out", (Object)printSink.toString());
            Assert.assertEquals((Object)("1> hello world!" + this.line), (Object)this.arrayOutputStream.toString());
        }
    }

    @Test
    void testPrintSinkWithIdentifierAndPrefix() throws Exception {
        PrintSink printSink = new PrintSink("mySink");
        try (SinkWriter writer = printSink.createWriter((Sink.InitContext)new MockInitContext(2));){
            writer.write((Object)"hello world!", (SinkWriter.Context)new MockContext());
            Assert.assertEquals((Object)"Print to System.out", (Object)printSink.toString());
            Assert.assertEquals((Object)("mySink:1> hello world!" + this.line), (Object)this.arrayOutputStream.toString());
        }
    }

    @Test
    void testPrintSinkWithIdentifierButNoPrefix() throws Exception {
        PrintSink printSink = new PrintSink("mySink");
        try (SinkWriter writer = printSink.createWriter((Sink.InitContext)new MockInitContext(1));){
            writer.write((Object)"hello world!", (SinkWriter.Context)new MockContext());
            Assert.assertEquals((Object)"Print to System.out", (Object)printSink.toString());
            Assert.assertEquals((Object)("mySink> hello world!" + this.line), (Object)this.arrayOutputStream.toString());
        }
    }

    private static class DummyMailboxExecutor
    implements MailboxExecutor {
        private DummyMailboxExecutor() {
        }

        public void execute(ThrowingRunnable<? extends Exception> command, String descriptionFormat, Object ... descriptionArgs) {
        }

        public void yield() throws InterruptedException, FlinkRuntimeException {
        }

        public boolean tryYield() throws FlinkRuntimeException {
            return false;
        }
    }

    private static class MockInitContext
    implements Sink.InitContext,
    SerializationSchema.InitializationContext {
        private final int numSubtasks;

        private MockInitContext(int numSubtasks) {
            this.numSubtasks = numSubtasks;
        }

        public UserCodeClassLoader getUserCodeClassLoader() {
            return SimpleUserCodeClassLoader.create((ClassLoader)PrintSinkTest.class.getClassLoader());
        }

        public MailboxExecutor getMailboxExecutor() {
            return new DummyMailboxExecutor();
        }

        public ProcessingTimeService getProcessingTimeService() {
            return new TestProcessingTimeService();
        }

        public int getSubtaskId() {
            return 0;
        }

        public int getNumberOfParallelSubtasks() {
            return this.numSubtasks;
        }

        public int getAttemptNumber() {
            return 0;
        }

        public SinkWriterMetricGroup metricGroup() {
            return InternalSinkWriterMetricGroup.mock((MetricGroup)new UnregisteredMetricsGroup());
        }

        public MetricGroup getMetricGroup() {
            return this.metricGroup();
        }

        public OptionalLong getRestoredCheckpointId() {
            return OptionalLong.empty();
        }

        public SerializationSchema.InitializationContext asSerializationSchemaInitializationContext() {
            return this;
        }
    }

    private static class MockContext
    implements SinkWriter.Context {
        private MockContext() {
        }

        public long currentWatermark() {
            return 0L;
        }

        public Long timestamp() {
            return System.currentTimeMillis();
        }
    }
}

