/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.io.network.api.writer.SubtaskStateMapper;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.InstantiationUtil;

@Internal
public class CustomPartitionerWrapper<K, T>
extends StreamPartitioner<T> {
    private static final long serialVersionUID = 1L;
    Partitioner<K> partitioner;
    KeySelector<T, K> keySelector;

    public CustomPartitionerWrapper(Partitioner<K> partitioner, KeySelector<T, K> keySelector) {
        this.partitioner = partitioner;
        this.keySelector = keySelector;
    }

    public int selectChannel(SerializationDelegate<StreamRecord<T>> record) {
        Object key;
        try {
            key = this.keySelector.getKey(((StreamRecord)record.getInstance()).getValue());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not extract key from " + record.getInstance(), e);
        }
        return this.partitioner.partition(key, this.numberOfChannels);
    }

    @Override
    public SubtaskStateMapper getDownstreamSubtaskStateMapper() {
        return SubtaskStateMapper.FULL;
    }

    @Override
    public StreamPartitioner<T> copy() {
        try {
            return new CustomPartitionerWrapper<K, T>((Partitioner)InstantiationUtil.clone(this.partitioner), this.keySelector);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException("Cannot clone custom partitioner", e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomPartitionerWrapper that = (CustomPartitionerWrapper)o;
        return this.numberOfChannels == that.numberOfChannels && Objects.equals(this.partitioner, that.partitioner) && Objects.equals(this.keySelector, that.keySelector);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.partitioner, this.keySelector);
    }

    @Override
    public boolean isPointwise() {
        return false;
    }

    public String toString() {
        return "CUSTOM";
    }
}

